/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.dataweave;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.mule.tooling.client.api.dataweave.DataWeaveModuleOption;
import org.mule.weave.v2.module.DataFormat;
import org.mule.weave.v2.module.DataFormatManager;
import org.mule.weave.v2.module.option.ModuleOption;
import scala.Option;
import scala.collection.JavaConverters$;

public class ModulesAnalyzer {
    public List<DataWeaveModuleOption> getOptions(String contentType, Function<DataFormat, scala.collection.immutable.Map<String, ModuleOption>> getter) {
        Option moduleOption = DataFormatManager.byContentType((String)contentType);
        if (moduleOption.nonEmpty()) {
            ArrayList<DataWeaveModuleOption> response = new ArrayList<DataWeaveModuleOption>();
            Map<String, ModuleOption> convert = this.convert(getter.apply((DataFormat)moduleOption.get()));
            convert.values().forEach(option -> response.add(this.toRestModel((ModuleOption)option)));
            return response;
        }
        throw new IllegalArgumentException("Module for " + contentType + " not found");
    }

    private <K, V> Map<K, V> convert(scala.collection.immutable.Map<K, V> m) {
        return (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(m).asJava();
    }

    private DataWeaveModuleOption toRestModel(ModuleOption option) {
        DataWeaveModuleOption model = new DataWeaveModuleOption();
        model.setName(option.name());
        model.setType(option.dataType().toString());
        model.setDefaultValue(this.toString(option));
        model.setDescription(option.description());
        model.setPossibleValues(option.possibleValues().mkString(","));
        return model;
    }

    private String toString(ModuleOption option) {
        return option.defaultValue().toString();
    }
}

