/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.mule.maven.client.api.MavenClient;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.api.MuleModule;
import org.mule.runtime.container.internal.CompositeModuleDiscoverer;
import org.mule.runtime.container.internal.ContainerClassLoaderFactory;
import org.mule.runtime.container.internal.JreModuleDiscoverer;
import org.mule.runtime.container.internal.ModuleDiscoverer;
import org.mule.runtime.core.api.util.PropertiesUtils;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ExportedService;
import org.mule.tooling.client.api.AbstractToolingRuntimeClientBuilderFactory;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.internal.CachedComponentBuildingDefinitionProviderLoader;
import org.mule.tooling.client.internal.CachedExtensionModelService;
import org.mule.tooling.client.internal.ComponentBuildingDefinitionLoader;
import org.mule.tooling.client.internal.DefaultExtensionModelService;
import org.mule.tooling.client.internal.DefaultToolingRuntimeClientBuilder;
import org.mule.tooling.client.internal.ExtensionModelServiceCache;
import org.mule.tooling.client.internal.MavenClientHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultToolingRuntimeClientFactory
extends AbstractToolingRuntimeClientBuilderFactory {
    private final ArtifactClassLoader containerClassLoaderFactory;
    private final ModuleRepository moduleRepository;
    private final ComponentBuildingDefinitionLoader componentBuildingDefinitionLoader;
    private ExtensionModelServiceCache extensionModelServiceCache = new ExtensionModelServiceCache();

    public DefaultToolingRuntimeClientFactory() {
        this.moduleRepository = DefaultToolingRuntimeClientFactory.createModuleRepository();
        this.containerClassLoaderFactory = DefaultToolingRuntimeClientFactory.createContainerClassLoader(this.moduleRepository);
        this.componentBuildingDefinitionLoader = new CachedComponentBuildingDefinitionProviderLoader();
    }

    public static ArtifactClassLoader createContainerClassLoader(ModuleRepository moduleRepository) {
        ArtifactClassLoader containerClassLoaderFactory = new ContainerClassLoaderFactory(moduleRepository).createContainerClassLoader(DefaultToolingRuntimeClientFactory.class.getClassLoader());
        return containerClassLoaderFactory;
    }

    public static ModuleRepository createModuleRepository() {
        ModuleDiscoverer jreModuleDiscoverer = new ModuleDiscoverer(){
            List<MuleModule> muleModules;

            public List<MuleModule> discover() {
                if (this.muleModules == null) {
                    this.muleModules = new JreModuleDiscoverer().discover();
                }
                return this.muleModules;
            }
        };
        CompositeModuleDiscoverer moduleDiscoverer = new CompositeModuleDiscoverer(new ModuleDiscoverer[]{jreModuleDiscoverer, new DuplicateClasspathModuleDiscoverer(DefaultToolingRuntimeClientFactory.class.getClassLoader())});
        return () -> DefaultToolingRuntimeClientFactory.lambda$createModuleRepository$0((ModuleDiscoverer)moduleDiscoverer);
    }

    public ToolingRuntimeClient.Builder create(MavenClient mavenClient) {
        MavenClientHolder mavenClientHolder = new MavenClientHolder(mavenClient);
        DefaultExtensionModelService extensionModelService = new DefaultExtensionModelService(mavenClientHolder, this.moduleRepository, this.containerClassLoaderFactory);
        return new DefaultToolingRuntimeClientBuilder(mavenClientHolder, new CachedExtensionModelService(this.extensionModelServiceCache, extensionModelService), this.componentBuildingDefinitionLoader);
    }

    public void dispose() {
        try {
            this.extensionModelServiceCache.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static List<ExportedService> getExportedServices(Properties moduleProperties, String exportedServicesProperty) {
        String privilegedExportedPackagesProperty = (String)moduleProperties.get(exportedServicesProperty);
        List<ExportedService> exportedServices = !StringUtils.isEmpty((CharSequence)privilegedExportedPackagesProperty) ? DefaultToolingRuntimeClientFactory.getServicesFromProperty(privilegedExportedPackagesProperty) : new ArrayList<ExportedService>();
        return exportedServices;
    }

    private static List<ExportedService> getServicesFromProperty(String privilegedExportedPackagesProperty) {
        ArrayList<ExportedService> exportedServices = new ArrayList<ExportedService>();
        for (String exportedServiceDefinition : privilegedExportedPackagesProperty.split(",")) {
            URL resource;
            String[] split = exportedServiceDefinition.split(":");
            String serviceInterface = split[0];
            String serviceImplementation = split[1];
            BytesURLStreamHandler bytesURLStreamHandler = new BytesURLStreamHandler(serviceImplementation.getBytes());
            try {
                resource = new URL("custom", "none", 9999, "none", bytesURLStreamHandler);
            }
            catch (MalformedURLException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
            exportedServices.add(new ExportedService(serviceInterface, resource));
        }
        return exportedServices;
    }

    private static /* synthetic */ List lambda$createModuleRepository$0(ModuleDiscoverer moduleDiscoverer) {
        return moduleDiscoverer.discover();
    }

    public static class BytesURLConnection
    extends URLConnection {
        protected byte[] content;

        public BytesURLConnection(URL url, byte[] content) {
            super(url);
            this.content = content;
        }

        @Override
        public void connect() {
        }

        @Override
        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.content);
        }
    }

    public static class BytesURLStreamHandler
    extends URLStreamHandler {
        byte[] content;

        public BytesURLStreamHandler(byte[] content) {
            this.content = content;
        }

        @Override
        public URLConnection openConnection(URL url) {
            return new BytesURLConnection(url, this.content);
        }
    }

    private static class DuplicateClasspathModuleDiscoverer
    implements ModuleDiscoverer {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private final ClassLoader classLoader;

        public DuplicateClasspathModuleDiscoverer(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public List<MuleModule> discover() {
            LinkedList<MuleModule> modules = new LinkedList<MuleModule>();
            HashSet<String> moduleNames = new HashSet<String>();
            try {
                for (Properties moduleProperties : PropertiesUtils.discoverProperties((ClassLoader)this.classLoader, (String)"META-INF/mule-module.properties")) {
                    MuleModule module = this.createModule(moduleProperties);
                    if (moduleNames.contains(module.getName())) {
                        this.logger.warn(String.format("Module '%s' was already defined", module.getName()));
                    }
                    moduleNames.add(module.getName());
                    modules.add(module);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot discover mule modules", e);
            }
            return modules;
        }

        private MuleModule createModule(Properties moduleProperties) {
            String moduleName = (String)moduleProperties.get("module.name");
            Set<String> modulePackages = this.getExportedPackageByProperty(moduleProperties, "artifact.export.classPackages");
            Set<String> modulePaths = this.getExportedResourcePaths(moduleProperties);
            Set<String> modulePrivilegedPackages = this.getExportedPackageByProperty(moduleProperties, "artifact.privileged.classPackages");
            Set<String> privilegedArtifacts = this.getPrivilegedArtifactIds(moduleProperties);
            List exportedServices = DefaultToolingRuntimeClientFactory.getExportedServices(moduleProperties, "artifact.export.services");
            return new MuleModule(moduleName, modulePackages, modulePaths, modulePrivilegedPackages, privilegedArtifacts, exportedServices);
        }

        private Set<String> getPrivilegedArtifactIds(Properties moduleProperties) {
            String privilegedArtifactsProperty = (String)moduleProperties.get("artifact.privileged.artifactIds");
            HashSet<String> artifactsIds = new HashSet<String>();
            if (!StringUtils.isEmpty((CharSequence)privilegedArtifactsProperty)) {
                for (String artifactName : privilegedArtifactsProperty.split(",")) {
                    if (StringUtils.isEmpty((CharSequence)artifactName.trim())) continue;
                    artifactsIds.add(artifactName);
                }
            }
            HashSet<String> privilegedArtifacts = artifactsIds;
            return privilegedArtifacts;
        }

        private Set<String> getExportedPackageByProperty(Properties moduleProperties, String privilegedExportedClassPackagesProperty) {
            String privilegedExportedPackagesProperty = (String)moduleProperties.get(privilegedExportedClassPackagesProperty);
            Set<String> modulePrivilegedPackages = !StringUtils.isEmpty((CharSequence)privilegedExportedPackagesProperty) ? this.getPackagesFromProperty(privilegedExportedPackagesProperty) : new HashSet<String>();
            return modulePrivilegedPackages;
        }

        private Set<String> getExportedResourcePaths(Properties moduleProperties) {
            HashSet<String> paths = new HashSet<String>();
            String exportedResourcesProperty = (String)moduleProperties.get("artifact.export.resources");
            if (!StringUtils.isEmpty((CharSequence)exportedResourcesProperty)) {
                for (String path : exportedResourcesProperty.split(",")) {
                    if (StringUtils.isEmpty((CharSequence)path.trim())) continue;
                    if (path.startsWith("/")) {
                        path = path.substring(1);
                    }
                    paths.add(path);
                }
            }
            return paths;
        }

        private Set<String> getPackagesFromProperty(String privilegedExportedPackagesProperty) {
            HashSet<String> packages = new HashSet<String>();
            for (String packageName : privilegedExportedPackagesProperty.split(",")) {
                if (StringUtils.isEmpty((CharSequence)(packageName = packageName.trim()))) continue;
                packages.add(packageName);
            }
            return packages;
        }
    }
}

