/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.util.Optional;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.runtime.module.embedded.api.EmbeddedContainer;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.configuration.agent.AgentConfiguration;
import org.mule.tooling.client.internal.ComponentBuildingDefinitionLoader;
import org.mule.tooling.client.internal.DefaultToolingRuntimeClient;
import org.mule.tooling.client.internal.MavenClientHolder;
import org.mule.tooling.client.internal.MuleRuntimeExtensionModelProvider;
import org.mule.tooling.client.internal.SpiRuntimeToolingServiceProvider;

public class DefaultToolingRuntimeClientBuilder
implements ToolingRuntimeClient.Builder {
    private final MuleRuntimeExtensionModelProvider muleRuntimeExtensionModelProvider;
    private final ComponentBuildingDefinitionLoader componentBuildingDefinitionLoader;
    private AgentConfiguration agentConfiguration;
    private MavenClientHolder mavenClientHolder;
    private EmbeddedContainer embeddedContainer;
    private AgentConfiguration embeddedAgentConfiguration;

    public DefaultToolingRuntimeClientBuilder(MavenClientHolder mavenClientHolder, MuleRuntimeExtensionModelProvider muleRuntimeExtensionModelProvider, ComponentBuildingDefinitionLoader componentBuildingDefinitionLoader) {
        this.mavenClientHolder = mavenClientHolder;
        this.muleRuntimeExtensionModelProvider = muleRuntimeExtensionModelProvider;
        this.componentBuildingDefinitionLoader = componentBuildingDefinitionLoader;
    }

    public ToolingRuntimeClient.Builder withRemoteAgentConfiguration(AgentConfiguration agentConfiguration) {
        this.agentConfiguration = agentConfiguration;
        return this;
    }

    public ToolingRuntimeClient.Builder withMavenConfiguration(MavenConfiguration mavenConfiguration) {
        this.mavenClientHolder.set(MavenClientProvider.discoverProvider((ClassLoader)DefaultToolingRuntimeClientBuilder.class.getClassLoader()).createMavenClient(mavenConfiguration));
        return this;
    }

    public ToolingRuntimeClient.Builder withEmbeddedContainer(EmbeddedContainer embeddedContainer, AgentConfiguration agentConfiguration) {
        this.embeddedContainer = embeddedContainer;
        this.embeddedAgentConfiguration = agentConfiguration;
        return this;
    }

    public ToolingRuntimeClient build() {
        return new DefaultToolingRuntimeClient(new SpiRuntimeToolingServiceProvider(), this.mavenClientHolder.get(), Optional.ofNullable(this.agentConfiguration), this.muleRuntimeExtensionModelProvider, this.componentBuildingDefinitionLoader, Optional.ofNullable(this.embeddedContainer), Optional.ofNullable(this.embeddedAgentConfiguration));
    }
}

