/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.base.Preconditions;
import java.net.URL;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.maven.client.api.MavenClient;
import org.mule.runtime.module.embedded.api.EmbeddedContainer;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.artifact.ConnectivityTestingServiceBuilder;
import org.mule.tooling.client.api.artifact.ToolingArtifact;
import org.mule.tooling.client.api.artifact.declaration.ArtifactSerializationService;
import org.mule.tooling.client.api.configuration.agent.AgentConfiguration;
import org.mule.tooling.client.api.exception.MissingToolingConfigurationException;
import org.mule.tooling.client.api.extension.ExtensionModelService;
import org.mule.tooling.client.api.tryit.TryItService;
import org.mule.tooling.client.internal.ComponentBuildingDefinitionLoader;
import org.mule.tooling.client.internal.DefaultToolingArtifact;
import org.mule.tooling.client.internal.DefaultTryItService;
import org.mule.tooling.client.internal.Initializable;
import org.mule.tooling.client.internal.MuleRuntimeExtensionModelProvider;
import org.mule.tooling.client.internal.TemporaryConnectivityTestingServiceBuilder;
import org.mule.tooling.client.internal.ToolingExtensionModelAdapter;
import org.mule.tooling.client.internal.artifact.DefaultArtifactSerializationService;

class DefaultToolingRuntimeClient
implements ToolingRuntimeClient {
    private final MavenClient mavenClient;
    private final ComponentBuildingDefinitionLoader componentBuildingDefinitionLoader;
    private final Optional<EmbeddedContainer> embeddedContainerOptional;
    private final Optional<AgentConfiguration> embeddedAgentConfigurationOptional;
    private AgentConfiguration agentConfiguration;
    private Supplier<RuntimeToolingService> runtimeToolingServiceSupplier;
    private RuntimeToolingService embeddedRuntimeToolingService;
    private RuntimeToolingService remoteRuntimeToolingService;
    private MuleRuntimeExtensionModelProvider muleRuntimeExtensionModelProvider;
    private ToolingExtensionModelAdapter toolingExtensionModelAdapter;
    private ArtifactSerializationService artifactSerializationService;
    private TryItService tryItService;

    DefaultToolingRuntimeClient(Supplier<RuntimeToolingService> runtimeToolingServiceSupplier, MavenClient mavenClient, Optional<AgentConfiguration> agentConfiguration, MuleRuntimeExtensionModelProvider muleRuntimeExtensionModelProvider, ComponentBuildingDefinitionLoader componentBuildingDefinitionLoader, Optional<EmbeddedContainer> embeddedContainerOptional, Optional<AgentConfiguration> embeddedAgentConfigurationOptional) {
        Preconditions.checkNotNull(runtimeToolingServiceSupplier, (Object)"runtimeToolingServiceSupplier cannot be null");
        Preconditions.checkNotNull((Object)mavenClient, (Object)"aetherDependencyResolver cannot be null");
        Preconditions.checkNotNull(agentConfiguration, (Object)"agentConfiguration cannot be null");
        Preconditions.checkNotNull(embeddedContainerOptional, (Object)"embeddedContainerOptional cannot be null");
        Preconditions.checkNotNull(embeddedAgentConfigurationOptional, (Object)"embeddedAgentConfigurationOptional cannot be null");
        Preconditions.checkState((!embeddedContainerOptional.isPresent() || embeddedAgentConfigurationOptional.isPresent() ? 1 : 0) != 0, (Object)"embeddedContainer configured but it's agent configuration is null");
        Preconditions.checkNotNull((Object)muleRuntimeExtensionModelProvider, (Object)"muleRuntimeExtensionModelProvider cannot be null");
        this.mavenClient = mavenClient;
        this.runtimeToolingServiceSupplier = runtimeToolingServiceSupplier;
        this.agentConfiguration = agentConfiguration.orElse(null);
        this.componentBuildingDefinitionLoader = componentBuildingDefinitionLoader;
        this.embeddedContainerOptional = embeddedContainerOptional;
        this.embeddedAgentConfigurationOptional = embeddedAgentConfigurationOptional;
        this.muleRuntimeExtensionModelProvider = muleRuntimeExtensionModelProvider;
        this.artifactSerializationService = new DefaultArtifactSerializationService(muleRuntimeExtensionModelProvider.getMuleExtensionModels(), muleRuntimeExtensionModelProvider, mavenClient);
        this.tryItService = new DefaultTryItService(this.lazyRemoteRuntimeToolingSupplier());
        this.initServices();
        this.toolingExtensionModelAdapter = new ToolingExtensionModelAdapter(muleRuntimeExtensionModelProvider);
    }

    private Supplier<RuntimeToolingService> lazyRuntimeToolingClientSupplier() {
        return () -> {
            if (this.embeddedRuntimeToolingService != null) {
                return this.embeddedRuntimeToolingService;
            }
            if (this.embeddedContainerOptional.isPresent()) {
                this.embeddedRuntimeToolingService = this.runtimeToolingServiceSupplier.get();
                this.embeddedRuntimeToolingService.setToolingApiUrl((URL)this.embeddedAgentConfigurationOptional.get().getToolingApiURLSupplier().get(), this.embeddedAgentConfigurationOptional.get().getDefaultConnectTimeout(), this.embeddedAgentConfigurationOptional.get().getDefaultReadTimeout(), Optional.empty());
                return this.embeddedRuntimeToolingService;
            }
            return this.lazyRemoteRuntimeToolingSupplier().get();
        };
    }

    private Supplier<RuntimeToolingService> lazyRemoteRuntimeToolingSupplier() {
        return () -> {
            if (this.remoteRuntimeToolingService != null) {
                return this.remoteRuntimeToolingService;
            }
            if (this.agentConfiguration == null) {
                throw new MissingToolingConfigurationException("Tooling Client has to be configure with a configuration to access REST Tooling API in order to resolve operations");
            }
            this.remoteRuntimeToolingService = this.runtimeToolingServiceSupplier.get();
            this.remoteRuntimeToolingService.setToolingApiUrl((URL)this.agentConfiguration.getToolingApiURLSupplier().get(), this.agentConfiguration.getDefaultConnectTimeout(), this.agentConfiguration.getDefaultReadTimeout(), this.agentConfiguration.getSSLContext());
            return this.remoteRuntimeToolingService;
        };
    }

    private void initServices() {
        this.initIfNeeded(this.muleRuntimeExtensionModelProvider);
        this.initIfNeeded(this.artifactSerializationService);
        this.initIfNeeded(this.tryItService);
    }

    private void initIfNeeded(Object service) {
        if (service instanceof Initializable) {
            ((Initializable)service).init();
        }
    }

    public ToolingArtifact newToolingArtifact(Supplier<URL> applicationUrlSupplier) {
        return new DefaultToolingArtifact(applicationUrlSupplier, this.lazyRuntimeToolingClientSupplier(), this.mavenClient, this.muleRuntimeExtensionModelProvider, this.componentBuildingDefinitionLoader);
    }

    public ToolingArtifact fetchToolingArtifact(String applicationId, Supplier<URL> applicationUrlSupplier) {
        return new DefaultToolingArtifact(applicationId, applicationUrlSupplier, this.lazyRuntimeToolingClientSupplier(), this.mavenClient, this.muleRuntimeExtensionModelProvider, this.componentBuildingDefinitionLoader);
    }

    public TryItService tryItService() {
        return this.tryItService;
    }

    public ConnectivityTestingServiceBuilder newConnectivityTestingService() {
        return new TemporaryConnectivityTestingServiceBuilder(this.lazyRuntimeToolingClientSupplier().get());
    }

    public ExtensionModelService extensionModelService() {
        return this.toolingExtensionModelAdapter;
    }

    public ArtifactSerializationService artifactSerializationService() {
        return this.artifactSerializationService;
    }
}

