/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.mulesoft.mule.runtime.config.spring.dsl.MuleEeExtensionModelProvider;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.core.api.util.Pair;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginClassLoaderFactory;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.plugin.BundlePluginDependenciesResolver;
import org.mule.runtime.deployment.model.internal.plugin.PluginDependenciesResolver;
import org.mule.runtime.deployment.model.internal.tooling.ToolingPluginClassLoaderBuilder;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.classloader.DeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.artifact.DescriptorLoaderRepository;
import org.mule.runtime.module.deployment.impl.internal.artifact.ExtensionModelDiscoverer;
import org.mule.runtime.module.deployment.impl.internal.plugin.ArtifactPluginDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.plugin.ArtifactPluginDescriptorLoader;
import org.mule.runtime.module.deployment.impl.internal.plugin.MuleExtensionModelLoaderManager;
import org.mule.runtime.module.deployment.impl.internal.plugin.PluginMavenClassLoaderModelLoader;
import org.mule.runtime.module.extension.internal.loader.ExtensionModelLoaderRepository;
import org.mule.runtime.module.extension.internal.resources.MuleExtensionModelProvider;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.Initializable;
import org.mule.tooling.client.internal.InternalExtensionModelService;
import org.mule.tooling.client.internal.MavenClientHolder;
import org.mule.tooling.client.internal.ToolingDescriptorLoaderRepository;

public class DefaultExtensionModelService
implements InternalExtensionModelService,
Initializable {
    private MavenClientHolder mavenClientHolder;
    private MavenClient mavenClient;
    private ModuleRepository moduleRepository = null;
    private ArtifactPluginDescriptorFactory artifactPluginDescriptorFactory;
    private ArtifactPluginDescriptorLoader artifactPluginDescriptorLoader;
    private ArtifactClassLoader containerArtifactClassLoader;
    private ExtensionModelDiscoverer extensionModelDiscoverer = new ExtensionModelDiscoverer();

    public DefaultExtensionModelService(MavenClientHolder mavenClientHolder, ModuleRepository moduleRepository, ArtifactClassLoader containerArtifactClassLoader) {
        this.mavenClientHolder = mavenClientHolder;
        this.moduleRepository = moduleRepository;
        this.containerArtifactClassLoader = containerArtifactClassLoader;
    }

    @Override
    public void init() {
        this.mavenClient = this.mavenClientHolder.get();
        MavenClientProvider mavenClientProvider = MavenClientProvider.discoverProvider((ClassLoader)this.getClass().getClassLoader());
        ToolingDescriptorLoaderRepository descriptorLoaderRepository = new ToolingDescriptorLoaderRepository(new PluginMavenClassLoaderModelLoader(this.mavenClient, mavenClientProvider.getLocalRepositorySuppliers()));
        this.artifactPluginDescriptorFactory = new ArtifactPluginDescriptorFactory((DescriptorLoaderRepository)descriptorLoaderRepository);
        this.artifactPluginDescriptorLoader = new ArtifactPluginDescriptorLoader(this.artifactPluginDescriptorFactory);
    }

    @Override
    public List<ExtensionModel> loadMuleExtensionModels() {
        return Arrays.asList(MuleExtensionModelProvider.getExtensionModel(), MuleEeExtensionModelProvider.getExtensionModel());
    }

    private Optional<Pair<ExtensionModel, ArtifactClassLoader>> resolveExtensionModel(ArtifactPluginDescriptor artifactPluginDescriptor) throws IOException, MuleException {
        ToolingPluginClassLoaderBuilder builder = new ToolingPluginClassLoaderBuilder((DeployableArtifactClassLoaderFactory)new TemporaryArtifactClassLoaderFactory(), (ArtifactClassLoaderFactory)new ArtifactPluginClassLoaderFactory(this.moduleRepository), (PluginDependenciesResolver)new BundlePluginDependenciesResolver((ArtifactDescriptorFactory)this.artifactPluginDescriptorFactory), artifactPluginDescriptor);
        builder.setParentClassLoader(this.containerArtifactClassLoader);
        ArtifactClassLoader pluginClassLoader = builder.build();
        MuleExtensionModelLoaderManager extensionModelLoaderRepository = new MuleExtensionModelLoaderManager(this.containerArtifactClassLoader);
        extensionModelLoaderRepository.start();
        Optional<ExtensionModel> extensionModel = this.getExtensionModel(artifactPluginDescriptor, pluginClassLoader, (ExtensionModelLoaderRepository)extensionModelLoaderRepository);
        if (!extensionModel.isPresent()) {
            pluginClassLoader.dispose();
            return Optional.empty();
        }
        return Optional.of(new Pair((Object)extensionModel.get(), (Object)pluginClassLoader));
    }

    private Optional<ExtensionModel> getExtensionModel(ArtifactPluginDescriptor artifactPluginDescriptor, ArtifactClassLoader pluginClassLoader, ExtensionModelLoaderRepository extensionModelLoaderRepository) {
        Set extensionModels = this.extensionModelDiscoverer.discoverExtensionModels(extensionModelLoaderRepository, (List)Lists.newArrayList((Object[])new Pair[]{new Pair((Object)artifactPluginDescriptor, (Object)pluginClassLoader)}));
        if (extensionModels.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(extensionModels.iterator().next());
    }

    @Override
    public Optional<Pair<ExtensionModel, ArtifactClassLoader>> loadPairArtifactClassLoaderAndExtensionModel(org.mule.tooling.client.api.descriptors.ArtifactDescriptor pluginDescriptor) {
        BundleDescriptor.Builder builder = new BundleDescriptor.Builder();
        builder.setGroupId(pluginDescriptor.getGroupId()).setArtifactId(pluginDescriptor.getArtifactId()).setType(pluginDescriptor.getExtension()).setVersion(pluginDescriptor.getVersion()).setClassifier(pluginDescriptor.getClassifier()).build();
        return this.loadPairArtifactClassLoaderAndExtensionModel(new File(this.mavenClient.resolveBundleDescriptor(builder.build()).getBundleUri()));
    }

    @Override
    public Optional<Pair<ExtensionModel, ArtifactClassLoader>> loadPairArtifactClassLoaderAndExtensionModel(File file) {
        File tempFolder = Files.createTempDir();
        try {
            ArtifactPluginDescriptor artifactPluginDescriptor = this.artifactPluginDescriptorLoader.load(file);
            Optional<Pair<ExtensionModel, ArtifactClassLoader>> optional = this.resolveExtensionModel(artifactPluginDescriptor);
            return optional;
        }
        catch (Exception e) {
            throw new ToolingException("Error while loading ExtensionModel for plugin: " + file.getAbsolutePath(), (Throwable)e);
        }
        finally {
            FileUtils.deleteQuietly((File)tempFolder);
        }
    }

    private class TemporaryArtifactClassLoaderFactory
    implements DeployableArtifactClassLoaderFactory<ArtifactDescriptor> {
        private TemporaryArtifactClassLoaderFactory() {
        }

        public ArtifactClassLoader create(String artifactId, ArtifactClassLoader parent, ArtifactDescriptor descriptor, List<ArtifactClassLoader> artifactPluginClassLoaders) {
            return new MuleDeployableArtifactClassLoader(artifactId, descriptor, descriptor.getClassLoaderModel().getUrls(), parent.getClassLoader(), parent.getClassLoaderLookupPolicy(), artifactPluginClassLoaders);
        }
    }
}

