/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.datasense.api.metadataprovider.XmlConfigurationDocumentLoader;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.config.spring.dsl.api.xml.StaticXmlNamespaceInfo;
import org.mule.runtime.config.spring.dsl.api.xml.StaticXmlNamespaceInfoProvider;
import org.mule.runtime.config.spring.dsl.model.ApplicationModel;
import org.mule.runtime.config.spring.dsl.model.ComponentBuildingDefinitionRegistry;
import org.mule.runtime.config.spring.dsl.processor.ArtifactConfig;
import org.mule.runtime.config.spring.dsl.processor.ConfigFile;
import org.mule.runtime.config.spring.dsl.processor.xml.XmlApplicationParser;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.collection.Collectors;
import org.mule.runtime.core.component.config.ClassLoaderResourceProvider;
import org.mule.runtime.core.component.config.ResourceProvider;
import org.mule.runtime.core.registry.SpiServiceRegistry;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinitionProvider;
import org.mule.runtime.dsl.api.xml.XmlNamespaceInfoProvider;
import org.mule.tooling.client.internal.ApplicationModelFactory;
import org.mule.tooling.client.internal.ComponentBuildingDefinitionLoader;
import org.w3c.dom.Document;

public abstract class BaseApplicationModelFactory
implements ApplicationModelFactory {
    protected static final String APP_TYPES_DATA = "application-types.xml";
    protected static final String MULE = "mule";
    private ComponentBuildingDefinitionLoader componentBuildingDefinitionLoader;

    public BaseApplicationModelFactory(ComponentBuildingDefinitionLoader componentBuildingDefinitionLoader) {
        this.componentBuildingDefinitionLoader = componentBuildingDefinitionLoader;
    }

    protected Optional<ConfigFile> loadConfigFile(String fileName, InputStream inputStream, Set<ExtensionModel> extensionModels) {
        return (Optional)ClassUtils.withContextClassLoader((ClassLoader)this.getClass().getClassLoader(), () -> {
            XmlApplicationParser xmlApplicationParser = new XmlApplicationParser((List)ImmutableList.of((Object)this.createStaticNamespaceInfoProviders(extensionModels)));
            XmlConfigurationDocumentLoader xmlConfigurationDocumentLoader = new XmlConfigurationDocumentLoader();
            Document document = xmlConfigurationDocumentLoader.loadDocument(inputStream);
            return xmlApplicationParser.parse(document.getDocumentElement()).map(configLine -> new ConfigFile(this.relativizeConfigFileName(fileName), Collections.singletonList(configLine)));
        });
    }

    private XmlNamespaceInfoProvider createStaticNamespaceInfoProviders(Set<ExtensionModel> extensionModels) {
        List extensionNamespaces = (List)extensionModels.stream().map(ext -> new StaticXmlNamespaceInfo(ext.getXmlDslModel().getNamespace(), ext.getXmlDslModel().getPrefix())).collect(Collectors.toImmutableList());
        return new StaticXmlNamespaceInfoProvider((Collection)extensionNamespaces);
    }

    private static String getMuleAppsFolder() {
        return MULE;
    }

    private String relativizeConfigFileName(String fileName) {
        if (fileName == null) {
            return null;
        }
        URI muleAppsURI = new File(BaseApplicationModelFactory.getMuleAppsFolder()).toURI();
        URI configFileURI = new File(fileName).toURI();
        return muleAppsURI.relativize(configFileURI).toString();
    }

    protected ApplicationModel loadApplicationModel(List<ConfigFile> configFiles, Set<ExtensionModel> extensionModels) throws Exception {
        ArtifactConfig.Builder builder = new ArtifactConfig.Builder();
        if (!configFiles.isEmpty()) {
            configFiles.forEach(configFile -> builder.addConfigFile(configFile));
        }
        ArtifactConfig artifactConfig = builder.build();
        ClassLoaderResourceProvider externalResourceProvider = new ClassLoaderResourceProvider(Thread.currentThread().getContextClassLoader());
        ApplicationModel applicationModel = new ApplicationModel(artifactConfig, null, extensionModels, Collections.emptyMap(), Optional.empty(), Optional.of(BaseApplicationModelFactory.createComponentBuildingDefinitionRegistry(extensionModels, this.componentBuildingDefinitionLoader)), false, (ResourceProvider)externalResourceProvider);
        return applicationModel;
    }

    private static ComponentBuildingDefinitionRegistry createComponentBuildingDefinitionRegistry(Set<ExtensionModel> extensionModels, ComponentBuildingDefinitionLoader componentBuildingDefinitionLoader) {
        SpiServiceRegistry serviceRegistry = new SpiServiceRegistry();
        ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry = new ComponentBuildingDefinitionRegistry();
        serviceRegistry.lookupProviders(ComponentBuildingDefinitionProvider.class, BaseApplicationModelFactory.class.getClassLoader()).forEach(componentBuildingDefinitionProvider -> componentBuildingDefinitionLoader.loadComponentBuildingDefinitions((ComponentBuildingDefinitionProvider)componentBuildingDefinitionProvider, extensionModels).forEach(arg_0 -> ((ComponentBuildingDefinitionRegistry)componentBuildingDefinitionRegistry).register(arg_0)));
        return componentBuildingDefinitionRegistry;
    }
}

