/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.application;

import org.mule.tooling.agent.RuntimeToolingService;

import java.net.URL;
import java.util.function.Supplier;

/**
 * Immutable implementation for {@link Deployable}.
 */
public class ImmutableApplicationDeployable implements Deployable {

  private String applicationId;
  private Supplier<URL> applicationUrlContentSupplier;
  private Supplier<RuntimeToolingService> runtimeToolingServiceSupplier;

  public ImmutableApplicationDeployable(String applicationId, Supplier<URL> applicationUrlContentSupplier,
                                        Supplier<RuntimeToolingService> runtimeToolingServiceSupplier) {
    this.applicationId = applicationId;
    this.applicationUrlContentSupplier = applicationUrlContentSupplier;
    this.runtimeToolingServiceSupplier = runtimeToolingServiceSupplier;
  }

  @Override
  public String getApplicationId() {
    return applicationId;
  }

  @Override
  public URL getApplicationUrlContent() {
    return applicationUrlContentSupplier.get();
  }

  @Override
  public RuntimeToolingService getRuntimeToolingService() {
    return runtimeToolingServiceSupplier.get();
  }
}
