/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.application;

import org.mule.tooling.agent.RuntimeToolingService;

import java.net.URL;

/**
 * Represents an application deployed to Mule Runtime.
 *
 * @since 4.0
 */
public interface Deployable {


  String getApplicationId();

  /**
   * @return {@link URL} with the location of the application content, either a file path with expanded content or a zip.
   */
  URL getApplicationUrlContent();

  RuntimeToolingService getRuntimeToolingService();

}
