/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.application;

public class CompositeApplicationDelegate implements ApplicationDelegate {

  private ApplicationDelegate runtimeApplicationDelegate;
  private ApplicationDelegate embeddedApplicationDelegate;

  public CompositeApplicationDelegate(ApplicationDelegate runtimeApplicationDelegate,
                                      ApplicationDelegate embeddedApplicationDelegate) {
    this.runtimeApplicationDelegate = runtimeApplicationDelegate;
    this.embeddedApplicationDelegate = embeddedApplicationDelegate;
  }

  @Override
  public void dispose() {
    this.embeddedApplicationDelegate.dispose();
  }

  @Override
  public Deployable deploy() {
    return embeddedApplicationDelegate.deploy();
  }
}
