/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal;

import static java.util.Optional.ofNullable;
import static org.mule.maven.client.api.MavenClientProvider.discoverProvider;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.runtime.module.embedded.api.EmbeddedContainer;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.ToolingRuntimeClient.Builder;
import org.mule.tooling.client.api.configuration.agent.AgentConfiguration;

/**
 * Default implementation of {@link Builder} that creates a {@link ToolingRuntimeClient}.
 *
 * @since 4.0
 */
public class DefaultToolingRuntimeClientBuilder implements Builder {

  private final MuleRuntimeExtensionModelProvider muleRuntimeExtensionModelProvider;
  private final ComponentBuildingDefinitionLoader componentBuildingDefinitionLoader;
  private AgentConfiguration agentConfiguration;
  private MavenClientHolder mavenClientHolder;
  private EmbeddedContainer embeddedContainer;
  private AgentConfiguration embeddedAgentConfiguration;

  public DefaultToolingRuntimeClientBuilder(MavenClientHolder mavenClientHolder,
                                            MuleRuntimeExtensionModelProvider muleRuntimeExtensionModelProvider,
                                            ComponentBuildingDefinitionLoader componentBuildingDefinitionLoader) {
    this.mavenClientHolder = mavenClientHolder;
    this.muleRuntimeExtensionModelProvider = muleRuntimeExtensionModelProvider;
    this.componentBuildingDefinitionLoader = componentBuildingDefinitionLoader;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Builder withRemoteAgentConfiguration(AgentConfiguration agentConfiguration) {
    this.agentConfiguration = agentConfiguration;
    return this;
  }

  @Override
  public Builder withMavenConfiguration(MavenConfiguration mavenConfiguration) {
    this.mavenClientHolder.set(discoverProvider(DefaultToolingRuntimeClientBuilder.class.getClassLoader())
        .createMavenClient(mavenConfiguration));
    return this;
  }

  @Override
  public Builder withEmbeddedContainer(EmbeddedContainer embeddedContainer, AgentConfiguration agentConfiguration) {
    this.embeddedContainer = embeddedContainer;
    this.embeddedAgentConfiguration = agentConfiguration;
    return this;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ToolingRuntimeClient build() {
    return new DefaultToolingRuntimeClient(new SpiRuntimeToolingServiceProvider(), mavenClientHolder.get(),
                                           ofNullable(agentConfiguration), muleRuntimeExtensionModelProvider,
                                           componentBuildingDefinitionLoader, ofNullable(embeddedContainer),
                                           ofNullable(embeddedAgentConfiguration));
  }

}
