/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal;

import static java.util.Objects.requireNonNull;
import static org.mule.tooling.client.internal.TimeoutMethodUtils.withTimeout;
import org.mule.tooling.client.api.connectivity.ConnectionValidationResult;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingObjectNotFoundException;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingRequest;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingService;
import org.mule.tooling.client.api.connectivity.UnsupportedConnectivityTestingObjectException;
import org.mule.tooling.client.api.exception.NoSuchApplicationException;
import org.mule.tooling.client.api.exception.ServiceUnavailableException;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.application.Deployable;

import java.util.function.Supplier;

/**
 * Default implementation of {@link ConnectivityTestingService}.
 *
 * @since 4.0
 */
public class DefaultConnectivityTestingService implements ConnectivityTestingService {

  private Supplier<Deployable> deployableApplicationSupplier;

  /**
   * Creates an instance of the service.
   *
   * @param deployableApplicationSupplier {@link Supplier} for a {@link Deployable}. Non null. Should return always the same instance.
   */
  public DefaultConnectivityTestingService(Supplier<Deployable> deployableApplicationSupplier) {
    requireNonNull(deployableApplicationSupplier, "deployableApplicationSupplier cannot be null");

    this.deployableApplicationSupplier = deployableApplicationSupplier;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ConnectionValidationResult testConnection(ConnectivityTestingRequest connectivityTestingRequest)
      throws NoSuchApplicationException, UnsupportedConnectivityTestingObjectException,
      ConnectivityTestingObjectNotFoundException, ToolingException, ServiceUnavailableException {
    return withTimeout(connectivityTestingRequest.getRequestTimeout(),
                       () -> {
                         Deployable deployable = this.deployableApplicationSupplier.get();
                         return deployable.getRuntimeToolingService()
                             .testConnection(deployable.getApplicationId(), connectivityTestingRequest.getComponentId());
                       }, null);
  }

}
