/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal;

import org.mule.datasense.api.metadataprovider.ApplicationModel;
import org.mule.runtime.api.meta.model.ExtensionModel;

import java.net.URL;
import java.util.Optional;
import java.util.Set;

/**
 * Creates a {@link org.mule.datasense.api.metadataprovider.ApplicationModel} from the application.
 *
 * @since 4.0
 */
public interface ApplicationModelFactory {

  /**
   * Creates the {@link ApplicationModel} from the application.
   *
   * @param applicationUrl {@link URL} to application content.
   * @param extensionModels {@link Set} of {@link ExtensionModel extension models} to be used for generating the application model.
   * @return an {@link Optional} {@link ApplicationModel}.
   * @throws Exception if an error happens while generating the {@link ApplicationModel}.
   */
  Optional<ApplicationModel> createApplicationModel(URL applicationUrl, Set<ExtensionModel> extensionModels);

}
