/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.pool.KryoPool;
import com.esotericsoftware.kryo.serializers.MapSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.serialization.KryoFactory;
import org.mule.tooling.client.internal.serialization.Serializer;
import org.mule.tooling.client.internal.serialization.TypeAnnotationMapReader;
import org.mule.tooling.client.internal.serialization.TypeAnnotationMapWriter;

public class KryoServerSerializer
implements Serializer {
    public static String NAME = "kryo";
    private KryoPool kryoPool = new KryoPool.Builder(() -> this.createKryo(sourceClassLoader, targetClassLoader, Collections.synchronizedList(new ArrayList()))).build();

    public KryoServerSerializer(ClassLoader sourceClassLoader, ClassLoader targetClassLoader) {
    }

    private Kryo createKryo(ClassLoader sourceClassLoader, ClassLoader targetClassLoader, List<Class> typeAnnotationsNotsupportedByToolingRuntimeClient) {
        Kryo kryo = KryoFactory.externalizableKryo((ClassLoader)targetClassLoader);
        kryo.setClassLoader(sourceClassLoader);
        kryo.register(LinkedHashMap.class, (com.esotericsoftware.kryo.Serializer)new TypeAnnotationsMapSerializer(targetClassLoader, typeAnnotationsNotsupportedByToolingRuntimeClient));
        return kryo;
    }

    public String serialize(Object object) {
        String string;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            try (Output output = new Output((OutputStream)byteArrayOutputStream);){
                this.kryoPool.run(kryo -> {
                    kryo.writeClassAndObject(output, object);
                    return null;
                });
            }
            string = Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ToolingException("Error while creating object from serialization", (Throwable)e);
            }
        }
        byteArrayOutputStream.close();
        return string;
    }

    public String safeSerialize(Object object) {
        String string;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            try (Output output = new Output((OutputStream)byteArrayOutputStream);){
                this.kryoPool.run(kryo -> {
                    kryo.writeObject(output, object);
                    return null;
                });
            }
            string = Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ToolingException("Error while creating object from serialization", (Throwable)e);
            }
        }
        byteArrayOutputStream.close();
        return string;
    }

    public <T> T deserialize(String content) {
        try (Input input = new Input((InputStream)new ByteArrayInputStream(Base64.getDecoder().decode(content)));){
            Object object = this.kryoPool.run(kryo -> kryo.readClassAndObject(input));
            return (T)object;
        }
    }

    public <T> T deserialize(String content, Class<T> clazz) {
        try (Input input = new Input((InputStream)new ByteArrayInputStream(Base64.getDecoder().decode(content)));){
            Object object = this.kryoPool.run(kryo -> kryo.readObject(input, clazz));
            return (T)object;
        }
    }

    private static class TypeAnnotationsMapSerializer
    extends MapSerializer {
        private TypeAnnotationMapWriter typeAnnotationMapWriter;
        private TypeAnnotationMapReader typeAnnotationMapReader;

        public TypeAnnotationsMapSerializer(ClassLoader targetClassLoader, List<Class> typeAnnotationsNotSupportedByToolingRuntimeClient) {
            this.typeAnnotationMapWriter = new TypeAnnotationMapWriter(targetClassLoader, typeAnnotationsNotSupportedByToolingRuntimeClient);
            this.typeAnnotationMapReader = new TypeAnnotationMapReader();
        }

        public void write(Kryo kryo, Output output, Map map) {
            super.write(kryo, output, this.typeAnnotationMapWriter.write(map));
        }

        public Map read(Kryo kryo, Input input, Class<Map> type) {
            Map original = super.read(kryo, input, type);
            return this.typeAnnotationMapReader.read(original);
        }
    }
}

