/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.api.analytics;

import com.mulesoft.mule.runtime.gw.api.analytics.PolicyViolationOutcome;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class PolicyViolation
implements Serializable {
    private static final long serialVersionUID = 2202279740569594769L;
    private String policyId;
    private PolicyViolationOutcome outcome;
    private String policyName;
    private String category;
    private Map<String, Object> extraData;

    private PolicyViolation() {
    }

    public static PolicyViolation from(PolicyViolation violation, Map<String, Object> extraData) {
        Builder b = PolicyViolation.builder().withPolicyName(violation.policyName).withPolicyId(violation.policyId).withCategory(violation.category).withOutcome(violation.outcome);
        extraData.forEach((k, v) -> b.withExtraData((String)k, v));
        return b.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public PolicyViolationOutcome getOutcome() {
        return this.outcome;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public String getCategory() {
        return this.category;
    }

    public Map<String, Object> getExtraData() {
        return this.extraData;
    }

    public String toString() {
        return "{outcome=" + String.valueOf((Object)this.outcome) + ", policyId=" + this.policyId + ", category=" + this.category + "}";
    }

    public static class Builder {
        private final PolicyViolation violation = new PolicyViolation();

        public Builder withPolicyId(String policyId) {
            this.violation.policyId = policyId;
            return this;
        }

        public Builder withOutcome(PolicyViolationOutcome outcome) {
            this.violation.outcome = outcome;
            return this;
        }

        public Builder withCategory(String category) {
            this.violation.category = category;
            return this;
        }

        public Builder withPolicyName(String policyName) {
            this.violation.policyName = policyName;
            return this;
        }

        public Builder withExtraData(String key, Object value) {
            if (this.violation.extraData == null) {
                this.violation.extraData = new HashMap<String, Object>();
            }
            this.violation.extraData.put(key, value);
            return this;
        }

        public PolicyViolation build() {
            return this.violation;
        }
    }
}

