/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.phase;

import java.util.List;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.api.model.v10.declarations.AnnotationTarget;
import org.raml.v2.internal.impl.commons.nodes.AnnotationNode;
import org.raml.v2.internal.impl.commons.nodes.AnnotationTypeNode;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationNode;
import org.raml.v2.internal.impl.commons.rule.RamlErrorNodeFactory;
import org.raml.v2.internal.impl.v10.type.TypeToRuleVisitor;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.phase.Phase;

public class AnnotationValidationPhase
implements Phase {
    private ResourceLoader resourceLoader;

    public AnnotationValidationPhase(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public Node apply(Node tree) {
        List annotations = tree.findDescendantsWith(AnnotationNode.class);
        for (AnnotationNode annotation : annotations) {
            String annotationName = annotation.getName();
            AnnotationTypeNode annotationTypeNode = annotation.getAnnotationTypeNode();
            if (annotationTypeNode == null) {
                annotation.replaceWith(ErrorNodeFactory.createMissingAnnotationType((String)annotationName));
                continue;
            }
            Node annotationValue = annotation.getValue();
            List<AnnotationTarget> allowedTargets = annotationTypeNode.getAllowedTargets();
            this.addTargetAliases(allowedTargets);
            AnnotationTarget target = annotation.getTarget();
            if (target != null && !allowedTargets.isEmpty() && !allowedTargets.contains((Object)target)) {
                annotationValue.replaceWith((Node)RamlErrorNodeFactory.createInvalidAnnotationTarget(allowedTargets, target));
            }
            TypeDeclarationNode typeNode = annotationTypeNode.getDeclaredType();
            Rule annotationRule = typeNode.getResolvedType().visit(new TypeToRuleVisitor(this.resourceLoader));
            annotationValue.replaceWith(annotationRule.apply(annotationValue));
        }
        return tree;
    }

    private void addTargetAliases(List<AnnotationTarget> allowedTargets) {
        if (allowedTargets.contains((Object)AnnotationTarget.TypeDeclaration)) {
            if (!allowedTargets.contains((Object)AnnotationTarget.RequestBody)) {
                allowedTargets.add(AnnotationTarget.RequestBody);
            }
            if (!allowedTargets.contains((Object)AnnotationTarget.ResponseBody)) {
                allowedTargets.add(AnnotationTarget.ResponseBody);
            }
        }
    }
}

