/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.rule;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.LogLevel;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.v2.internal.impl.commons.type.JsonSchemaExternalType;
import org.raml.v2.internal.utils.JSonDumper;
import org.raml.v2.internal.utils.SchemaGenerator;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.StringNode;
import org.raml.yagi.framework.nodes.jackson.JsonUtils;
import org.raml.yagi.framework.suggester.ParsingContext;
import org.raml.yagi.framework.suggester.Suggestion;

public class JsonSchemaValidationRule
extends Rule {
    public static final String JSON_SCHEMA_FAIL_ON_WARNING_KEY = "raml.json_schema.fail_on_warning";
    private final boolean FAIL_ON_WARNING = Boolean.valueOf(System.getProperty("raml.json_schema.fail_on_warning", "false"));
    private JsonSchemaExternalType node;
    private JsonSchema schema;

    public JsonSchemaValidationRule(JsonSchemaExternalType schemaNode) {
        try {
            this.node = schemaNode;
            this.schema = SchemaGenerator.generateJsonSchema(schemaNode);
        }
        catch (Exception e) {
            this.schema = null;
        }
    }

    @Nonnull
    public List<Suggestion> getSuggestions(Node node, ParsingContext context) {
        return Lists.newArrayList();
    }

    public boolean matches(@Nonnull Node node) {
        return node instanceof StringNode;
    }

    @Nonnull
    public Node apply(@Nonnull Node node) {
        if (this.schema == null) {
            return ErrorNodeFactory.createInvalidJsonExampleNode((String)"Invalid JsonSchema");
        }
        try {
            String value = node instanceof StringNode ? ((StringNode)node).getValue() : JSonDumper.dump(node);
            if (value == null) {
                return ErrorNodeFactory.createInvalidJsonExampleNode((String)("Source example is not valid: " + node));
            }
            JsonNode json = JsonUtils.parseJson((String)value);
            ProcessingReport report = this.schema.validate(json);
            Iterator iterator = report.iterator();
            ArrayList errors = Lists.newArrayList();
            while (iterator.hasNext()) {
                ProcessingMessage next = (ProcessingMessage)iterator.next();
                LogLevel logLevel = next.getLogLevel();
                if (!logLevel.equals((Object)LogLevel.ERROR) && (!logLevel.equals((Object)LogLevel.WARNING) || !this.FAIL_ON_WARNING)) continue;
                errors.add(this.processErrorMessage(next.toString()));
            }
            if (!errors.isEmpty()) {
                return ErrorNodeFactory.createInvalidJsonExampleNode((String)("{\n" + Joiner.on((String)",\n").join((Iterable)errors) + "\n}"));
            }
        }
        catch (JsonParseException e) {
            return ErrorNodeFactory.createInvalidJsonExampleNode((String)e.getOriginalMessage());
        }
        catch (ProcessingException | IOException e) {
            return ErrorNodeFactory.createInvalidJsonExampleNode((String)("Invalid json content. " + e.getMessage()));
        }
        return node;
    }

    public String getDescription() {
        return "JSON Schema validation rule";
    }

    private String processErrorMessage(String processingMessage) {
        String SCHEMA_TEXT = "schema: {\"loadingURI\":\"";
        String POINTER_TEXT = "\"pointer\":\"";
        int startOfSchema = processingMessage.indexOf("schema: {\"loadingURI\":\"");
        if (startOfSchema >= 0) {
            int startOfPointer = processingMessage.indexOf("\"pointer\":\"");
            String completeUri = processingMessage.substring(startOfSchema + "schema: {\"loadingURI\":\"".length(), startOfPointer - 2);
            String reducedSchemaURI = completeUri.substring(completeUri.lastIndexOf(47) + 1);
            return processingMessage.replace(completeUri, reducedSchemaURI);
        }
        return processingMessage;
    }
}

