/*
 * Decompiled with CFR 0.152.
 */
package com.conversantmedia.util.concurrent;

import com.conversantmedia.util.concurrent.Condition;

public abstract class AbstractSpinningCondition
implements Condition {
    @Override
    public void awaitNanos(long timeout) throws InterruptedException {
        long timeNow = System.nanoTime();
        long expires = timeNow + timeout;
        Thread t = Thread.currentThread();
        while (this.test() && expires > timeNow && !t.isInterrupted()) {
            timeNow = System.nanoTime();
            Condition.onSpinWait();
        }
        if (t.isInterrupted()) {
            throw new InterruptedException();
        }
    }

    @Override
    public void await() throws InterruptedException {
        Thread t = Thread.currentThread();
        while (this.test() && !t.isInterrupted()) {
            Condition.onSpinWait();
        }
        if (t.isInterrupted()) {
            throw new InterruptedException();
        }
    }

    @Override
    public void signal() {
    }
}

