/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.processor;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.privileged.processor.MessageProcessorBuilder;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.AbstractMessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChainBuilder;
import org.mule.runtime.dsl.api.component.AbstractComponentFactory;

@NoExtend
public class MessageProcessorChainFactoryBean
extends AbstractComponentFactory<MessageProcessorChain>
implements MuleContextAware {
    protected List processors;
    protected String name;
    protected MuleContext muleContext;
    @Inject
    protected ConfigurationComponentLocator locator;

    public void setMessageProcessors(List processors) {
        this.processors = processors;
    }

    public Map<QName, Object> getAnnotations() {
        return Collections.emptyMap();
    }

    public MessageProcessorChain doGetObject() throws Exception {
        MessageProcessorChainBuilder builder = this.getBuilderInstance();
        for (Object processor : this.processors) {
            if (processor instanceof Processor) {
                builder.chain(new Processor[]{(Processor)processor});
                continue;
            }
            if (processor instanceof MessageProcessorBuilder) {
                builder.chain(new MessageProcessorBuilder[]{(MessageProcessorBuilder)processor});
                continue;
            }
            throw new IllegalArgumentException(String.format("MessageProcessorBuilder should only have MessageProcessor's or MessageProcessorBuilder's configured. Found a %s", processor.getClass().getName()));
        }
        return DefaultMessageProcessorChainBuilder.newLazyProcessorChainBuilder((AbstractMessageProcessorChainBuilder)((DefaultMessageProcessorChainBuilder)builder), (MuleContext)this.muleContext, () -> MessageProcessors.getProcessingStrategy((ConfigurationComponentLocator)this.locator, (Component)this).orElse(null));
    }

    protected MessageProcessorChainBuilder getBuilderInstance() {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.setName("processor chain '" + this.name + "'");
        return builder;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

