/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.api.builder;

import java.util.ServiceLoader;
import org.mule.framework.api.MuleFramework;
import org.mule.runtime.container.api.ModuleRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMuleFrameworkBuilderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMuleFrameworkBuilderFactory.class);
    private static final AbstractMuleFrameworkBuilderFactory DEFAULT_FACTORY;

    public static AbstractMuleFrameworkBuilderFactory getDefaultFactory() {
        return DEFAULT_FACTORY;
    }

    public abstract MuleFramework.Builder create();

    public abstract MuleFramework.Builder create(ClassLoader var1, ModuleRepository var2);

    public abstract void keepServicesAliveAfterLastFrameworkClosed(boolean var1);

    public abstract void disposeServices();

    static {
        try {
            AbstractMuleFrameworkBuilderFactory factory = ServiceLoader.load(AbstractMuleFrameworkBuilderFactory.class, AbstractMuleFrameworkBuilderFactory.class.getClassLoader()).iterator().next();
            LOGGER.info(String.format("Loaded AbstractMuleFrameworkBuilderFactory implementation '%s' from classloader '%s'", factory.getClass().getName(), factory.getClass().getClassLoader().toString()));
            DEFAULT_FACTORY = factory;
        }
        catch (Throwable t) {
            LOGGER.error("Error loading AbstractMuleFrameworkBuilderFactory implementation.", t);
            throw t;
        }
    }
}

