/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.introspector.internal.extractor.schedulers;

import com.mulesoft.runtime.introspector.model.scheduler.CronScheduler;
import com.mulesoft.runtime.introspector.model.scheduler.FixedFrequencyScheduler;
import com.mulesoft.runtime.introspector.model.scheduler.Scheduler;
import com.mulesoft.runtime.introspector.model.scheduler.SchedulerFlow;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;

public class SchedulersDataExtractor {
    private static final String CORE_PREFIX = "mule";
    private static final String DEFAULT_NAMESPACE_URI_MASK = "http://www.mulesoft.org/schema/mule/%s";
    private static final String CORE_NAMESPACE = String.format("http://www.mulesoft.org/schema/mule/%s", "core");
    private static final String DESCRIPTION_DOC_PARAM = "description";
    private static final String MAX_CONCURRENCY_PARAM = "maxConcurrency";
    private static final String SCHEDULING_STRATEGY_PARAM = "schedulingStrategy";
    private static final String FIXED_FREQUENCY_SCH_PARAM_VALUE = "fixed-frequency";
    private static final String START_DELAY_PARAM = "startDelay";
    private static final String FREQUENCY_PARAM = "frequency";
    private static final String TIME_UNIT_PARAM = "timeUnit";
    private static final String CRON_SCH_PARAM_VALUE = "cron";
    private static final String CRON_EXPRESSION_PARAM = "expression";
    private static final String TIME_ZONE_PARAM = "timeZone";
    public static final String SCHEDULERS_KEY = "schedulers";
    private static final ComponentIdentifier CRON_IDENTIFIER = ComponentIdentifier.builder().namespaceUri(CORE_NAMESPACE).namespace("mule").name("cron").build();
    private static final ComponentIdentifier FIXED_FREQUENCY_IDENTIFIER = ComponentIdentifier.builder().namespaceUri(CORE_NAMESPACE).namespace("mule").name("fixed-frequency").build();
    private final Map<ComponentIdentifier, Function<ComponentAst, Object>> schedulerExtractors = new HashMap<ComponentIdentifier, Function<ComponentAst, Object>>();

    public SchedulersDataExtractor() {
        this.schedulerExtractors.put(FIXED_FREQUENCY_IDENTIFIER, this::extractFixedFrequencyStrategyParameters);
        this.schedulerExtractors.put(CRON_IDENTIFIER, this::extractCronStrategyParameters);
    }

    public Map<String, SchedulerFlow> extractFrom(ArtifactAst artifact) {
        LinkedHashMap<String, SchedulerFlow> schedulersMap = new LinkedHashMap<String, SchedulerFlow>();
        artifact.topLevelComponentsStream().filter(comp -> comp.getComponentType().equals((Object)TypedComponentIdentifier.ComponentType.FLOW)).forEach(flow -> flow.directChildrenStream().filter(comp -> comp.getComponentType().equals((Object)TypedComponentIdentifier.ComponentType.SOURCE)).filter(src -> src.getParameter("General", SCHEDULING_STRATEGY_PARAM) != null).forEach(src -> schedulersMap.put((String)flow.getComponentId().get(), this.extractFlowScheduler((ComponentAst)flow, (ComponentAst)src))));
        return schedulersMap;
    }

    public SchedulerFlow extractFlowScheduler(ComponentAst flow, ComponentAst src) {
        LinkedHashMap<String, Object> flowOut = new LinkedHashMap<String, Object>();
        String description = null;
        Map docAttributes = flow.getMetadata().getDocAttributes();
        if (docAttributes.containsKey(DESCRIPTION_DOC_PARAM)) {
            flowOut.put(DESCRIPTION_DOC_PARAM, docAttributes.get(DESCRIPTION_DOC_PARAM));
            description = (String)docAttributes.get(DESCRIPTION_DOC_PARAM);
        }
        this.putIfPresent(flowOut, MAX_CONCURRENCY_PARAM, flow.getParameter("General", MAX_CONCURRENCY_PARAM));
        Scheduler scheduler = (Scheduler)src.getParameter("General", SCHEDULING_STRATEGY_PARAM).getValue().mapRight(sch -> {
            ComponentAst schedulerComponent = (ComponentAst)sch;
            if (this.schedulerExtractors.containsKey(schedulerComponent.getIdentifier())) {
                return (Scheduler)this.schedulerExtractors.get(schedulerComponent.getIdentifier()).apply(schedulerComponent);
            }
            return null;
        }).getRight();
        return new SchedulerFlow(description, this.getParamValueAsString(flow.getParameter("General", MAX_CONCURRENCY_PARAM)), scheduler);
    }

    private FixedFrequencyScheduler extractFixedFrequencyStrategyParameters(ComponentAst scheduler) {
        return new FixedFrequencyScheduler(this.getParamValueAsString(scheduler.getParameter(FIXED_FREQUENCY_SCH_PARAM_VALUE, TIME_UNIT_PARAM)), this.getParamValueAsString(scheduler.getParameter(FIXED_FREQUENCY_SCH_PARAM_VALUE, FREQUENCY_PARAM)), this.getParamValueAsString(scheduler.getParameter(FIXED_FREQUENCY_SCH_PARAM_VALUE, START_DELAY_PARAM)));
    }

    private CronScheduler extractCronStrategyParameters(ComponentAst scheduler) {
        return new CronScheduler(this.getParamValueAsString(scheduler.getParameter(CRON_SCH_PARAM_VALUE, CRON_EXPRESSION_PARAM)), this.getParamValueAsString(scheduler.getParameter(CRON_SCH_PARAM_VALUE, TIME_ZONE_PARAM)));
    }

    private <T> void putIfPresent(Map<String, Object> out, String outParamName, ComponentParameterAst param) {
        String value = this.getParamValueAsString(param);
        if (value != null) {
            out.put(outParamName, value);
        }
    }

    private String getParamValueAsString(ComponentParameterAst param) {
        Object value;
        if (param.getValue() != null && param.getValue().isRight() && (value = param.getValue().getRight()) != null) {
            return value.toString();
        }
        return null;
    }
}

