/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.introspector.ang;

import com.mulesoft.runtime.ang.classpath.ModuleRepositoryGenerator;
import com.mulesoft.runtime.introspector.IntrospectionResult;
import com.mulesoft.runtime.introspector.ang.exception.IntrospectorException;
import com.mulesoft.runtime.introspector.ang.exception.InvalidApplicationException;
import com.mulesoft.runtime.introspector.exception.IntrospectionException;
import com.mulesoft.runtime.introspector.internal.extractor.MuleArtifactDataExtractor;
import com.mulesoft.runtime.introspector.internal.yaml.IntrospectionResultYamlFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.mule.framework.api.MuleFramework;
import org.mule.framework.api.exception.FrameworkBuildException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.slf4j.Logger;

public class MuleApplicationAngFn {
    public static final String FORCE_CONFIG_PARSE_PROPERTY = "mule.angis.forceConfigParse";
    private final Logger log;
    private final ModuleRepository moduleRepository;
    private final MuleArtifactDataExtractor muleArtifactAngDataExtractor;
    private static final List<String> ERROR_MESSAGE_LIST = List.of("Could not create classloader-model.json", "Error deserializing 'classloader-model.json'");

    public MuleApplicationAngFn(Logger log) {
        this.log = log;
        try {
            this.moduleRepository = new ModuleRepositoryGenerator().read();
        }
        catch (IOException e) {
            throw new IntrospectorException("Unable to read moduleRepository data.", e);
        }
        this.muleArtifactAngDataExtractor = new MuleArtifactDataExtractor();
    }

    public String handle(String appFileName, InputStream muleAppJarFileContent, Map<String, Object> baseAppData) {
        return this.handle(appFileName, muleAppJarFileContent, baseAppData, Optional.empty(), bundleDescriptor -> null);
    }

    public String handle(String appFileName, InputStream muleAppJarFileContent, Map<String, Object> baseAppData, Optional<Integer> muleRuntimeMajorVersion) {
        return this.handle(appFileName, muleAppJarFileContent, baseAppData, muleRuntimeMajorVersion, bundleDescriptor -> null);
    }

    public String handle(String appFileName, InputStream muleAppJarFileContent, Map<String, Object> baseAppData, Function<BundleDescriptor, InputStream> domainResolver) {
        return this.handle(appFileName, muleAppJarFileContent, baseAppData, Optional.empty(), domainResolver);
    }

    public String handle(String appFileName, InputStream muleAppJarFileContent, Map<String, Object> baseAppData, Optional<Integer> muleRuntimeMajorVersion, Function<BundleDescriptor, InputStream> domainResolver) {
        if (muleRuntimeMajorVersion.map(v -> v.equals(4)).orElse(false).booleanValue()) {
            this.log.debug("Introspecting Mule 4 application...");
            this.handleMule4Application(appFileName, muleAppJarFileContent, baseAppData, domainResolver);
        } else {
            this.log.info("Not instrospecting application. muleRuntimeMajorVersion=" + muleRuntimeMajorVersion);
        }
        this.log.debug("Generating YAML with extracted data...");
        StringWriter outputWriter = new StringWriter();
        outputWriter.write("#%Application 1.0" + System.lineSeparator() + System.lineSeparator());
        IntrospectionResultYamlFactory.createYaml().dump(baseAppData, (Writer)outputWriter);
        this.log.info("Finished processing artifact '{}'.", (Object)appFileName);
        return outputWriter.toString();
    }

    protected void handleMule4Application(String appFileName, InputStream muleAppJarFileContent, Map<String, Object> baseAppData, Function<BundleDescriptor, InputStream> domainResolver) {
        AtomicReference<File> domainWorkDir;
        block7: {
            domainWorkDir = new AtomicReference<File>();
            File workdir = null;
            String workDirPrefix = UUID.randomUUID().toString();
            try {
                workdir = Files.createTempDirectory(workDirPrefix, new FileAttribute[0]).toFile();
                File appFolder = new File(workdir, appFileName + UUID.randomUUID());
                this.handleWithWorkDir(appFolder, appFileName, muleAppJarFileContent, baseAppData, domainWorkDir, domainResolver);
                if (workdir == null) break block7;
            }
            catch (IOException e) {
                try {
                    throw new IntrospectorException(String.format("Unable to create work directory with prefix '%s'", workDirPrefix), e);
                }
                catch (Throwable throwable) {
                    if (workdir != null) {
                        org.apache.commons.io.FileUtils.deleteQuietly((File)workdir);
                    }
                    if (domainWorkDir.get() != null) {
                        org.apache.commons.io.FileUtils.deleteQuietly((File)((File)domainWorkDir.get()));
                    }
                    throw throwable;
                }
            }
            org.apache.commons.io.FileUtils.deleteQuietly((File)workdir);
        }
        if (domainWorkDir.get() != null) {
            org.apache.commons.io.FileUtils.deleteQuietly((File)domainWorkDir.get());
        }
    }

    protected void handleWithWorkDir(File appFolder, String appFileName, InputStream muleAppJarFileContent, Map<String, Object> baseAppData, AtomicReference<File> domainWorkDir, Function<BundleDescriptor, InputStream> domainResolver) {
        this.log.info("Processing artifact '{}'...", (Object)appFileName);
        try {
            this.log.debug("Unzipping mule-application jar file...");
            FileUtils.unzip((InputStream)muleAppJarFileContent, (File)appFolder, (boolean)false, (boolean)false);
            this.log.debug("Loading artifact AST...");
            try (MuleFramework muleFramework = MuleFramework.builder((ClassLoader)this.getClass().getClassLoader(), (ModuleRepository)this.moduleRepository).fromPackagedApplication(appFolder.toPath(), applicationConfigurer -> applicationConfigurer.withDomain(bundleDescriptor -> {
                String workDirPrefix = UUID.randomUUID().toString();
                try {
                    domainWorkDir.set(Files.createTempDirectory(workDirPrefix, new FileAttribute[0]).toFile());
                    InputStream muleDomainJarFileContent = (InputStream)domainResolver.apply((BundleDescriptor)bundleDescriptor);
                    if (muleDomainJarFileContent == null) {
                        return null;
                    }
                    this.log.debug("Unzipping mule-domain jar file...");
                    FileUtils.unzip((InputStream)muleDomainJarFileContent, (File)((File)domainWorkDir.get()), (boolean)false, (boolean)false);
                }
                catch (Exception e) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Unable to prepare domain '%s'", bundleDescriptor.getArtifactId())), (Throwable)e);
                }
                return MuleFramework.builder((ClassLoader)this.getClass().getClassLoader(), (ModuleRepository)this.moduleRepository).fromPackagedDomain(((File)domainWorkDir.get()).toPath(), Boolean.getBoolean(FORCE_CONFIG_PARSE_PROPERTY)).usageMode(MuleFramework.UsageMode.ARTIFACT_AST).build();
            }), Boolean.getBoolean(FORCE_CONFIG_PARSE_PROPERTY)).usageMode(MuleFramework.UsageMode.ARTIFACT_AST).build();){
                this.log.debug("Extracting data from AST...");
                muleFramework.onExecutionClassLoader(() -> {
                    IntrospectionResult result;
                    try {
                        result = this.getMuleArtifactAngDataExtractor().extractFrom(CompletableFuture.completedFuture((ArtifactAst)muleFramework.getArtifactAst().get()), CompletableFuture.completedFuture(Thread.currentThread().getContextClassLoader()), CompletableFuture.completedFuture(muleFramework.getDeployableProjectModel()), Optional.of(appFolder.toPath()), Collections.emptySet(), ForkJoinPool.commonPool());
                    }
                    catch (IntrospectionException e) {
                        throw new RuntimeException(e);
                    }
                    baseAppData.put("flows", result.getFlows());
                    baseAppData.put("schedulers", result.getSchedulers());
                    baseAppData.put("config-properties", result.getConfigProperties());
                    baseAppData.put("nativeLibraries", result.getNativeLibraries());
                    baseAppData.put("javaComponents", result.getJavaComponents());
                });
            }
            catch (FrameworkBuildException e) {
                this.handleInvalidApplication(e);
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Unable to build MuleFramework for application '%s'", appFileName)), (Throwable)e);
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Unable to introspect application '%s'", appFileName)), (Throwable)e);
            }
        }
        catch (IOException e) {
            throw new IntrospectorException(String.format("Unable to unzip jar file '%s' into work directory '%s'", appFileName, appFolder.getAbsolutePath()), e);
        }
    }

    protected MuleArtifactDataExtractor getMuleArtifactAngDataExtractor() {
        return this.muleArtifactAngDataExtractor;
    }

    public Optional<Integer> extractMuleRuntimeMajorVersion(Optional<String> minMuleVersion) {
        return minMuleVersion.flatMap(v -> {
            String[] versionParts = v.split("\\.");
            if (versionParts.length == 0) {
                return Optional.empty();
            }
            try {
                return Optional.of(Integer.parseInt(versionParts[0]));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        });
    }

    private void handleInvalidApplication(FrameworkBuildException e) {
        List<Class> exceptionClasses = Arrays.asList(FileNotFoundException.class, IllegalStateException.class);
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            for (Class exceptionClass : exceptionClasses) {
                if (!exceptionClass.isInstance(cause) || !ERROR_MESSAGE_LIST.stream().anyMatch(message -> e.getMessage().contains((CharSequence)message))) continue;
                throw new InvalidApplicationException(e.getMessage(), (Exception)((Object)e));
            }
        }
    }
}

