/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.introspector;

import com.mulesoft.runtime.introspector.IntrospectionResults;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;

public class IntrospectionRequest {
    private final ArtifactAst artifactAst;
    private final ClassLoader appClassloader;
    private final DeployableProjectModel deployableProjectModel;
    private final Path artifactPath;
    private final Set<IntrospectionResults> wantedResults;
    private final Optional<Executor> executor;

    private IntrospectionRequest(Builder builder) {
        this.artifactAst = builder.artifactAst;
        this.appClassloader = builder.appClassloader;
        this.deployableProjectModel = builder.deployableProjectModel;
        this.artifactPath = builder.artifactPath;
        this.wantedResults = builder.wantedResults != null ? builder.wantedResults : Collections.emptySet();
        this.executor = Optional.ofNullable(builder.executor);
    }

    public ArtifactAst getArtifactAst() {
        return this.artifactAst;
    }

    public ClassLoader getAppClassloader() {
        return this.appClassloader;
    }

    public DeployableProjectModel getDeployableProjectModel() {
        return this.deployableProjectModel;
    }

    public Path getArtifactPath() {
        return this.artifactPath;
    }

    public Set<IntrospectionResults> getWantedResults() {
        return this.wantedResults;
    }

    public Optional<Executor> getExecutor() {
        return this.executor;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ArtifactAst artifactAst;
        private ClassLoader appClassloader;
        private DeployableProjectModel deployableProjectModel;
        private Path artifactPath;
        private final Set<IntrospectionResults> wantedResults = new HashSet<IntrospectionResults>();
        private Executor executor;

        public Builder withArtifactAst(ArtifactAst artifactAst) {
            this.artifactAst = artifactAst;
            return this;
        }

        public Builder withAppClassloader(ClassLoader appClassloader) {
            this.appClassloader = appClassloader;
            return this;
        }

        public Builder withDeployableProjectModel(DeployableProjectModel deployableProjectModel) {
            this.deployableProjectModel = deployableProjectModel;
            return this;
        }

        public Builder withArtifactPath(Path artifactPath) {
            this.artifactPath = artifactPath;
            return this;
        }

        public Builder withWantedResult(IntrospectionResults wantedIntrospectionResult) {
            this.wantedResults.add(wantedIntrospectionResult);
            return this;
        }

        public Builder withWantedResults(IntrospectionResults ... wantedIntrospectionResults) {
            this.wantedResults.addAll(Arrays.asList(wantedIntrospectionResults));
            return this;
        }

        public Builder withWantedResults(Collection<IntrospectionResults> wantedIntrospectionResults) {
            this.wantedResults.addAll(wantedIntrospectionResults);
            return this;
        }

        public Builder withExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public IntrospectionRequest build() {
            return new IntrospectionRequest(this);
        }
    }
}

