/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.store;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class PolicyStoreFiles {
    private File policiesWorkingDir;

    public PolicyStoreFiles(File policiesWorkingDir) {
        this.policiesWorkingDir = policiesWorkingDir;
    }

    public List<File> listPolicyFolders() {
        return Arrays.asList(this.policiesWorkingDir.listFiles(file -> file.isDirectory() && !file.getName().equals("failed-policies") && !file.getName().equals("policy-templates") && !file.getName().equals("offline-policies") && !file.getName().equals("hdp-api-registry")));
    }

    public List<File> listOfflinePoliciesDescriptors() {
        File offlinePoliciesFolder = new File(this.policiesWorkingDir, "offline-policies");
        return offlinePoliciesFolder.exists() ? Arrays.asList(offlinePoliciesFolder.listFiles(file -> !file.isDirectory())) : Collections.emptyList();
    }

    public File getFailedPoliciesFolder() {
        return new File(this.policiesWorkingDir, "failed-policies");
    }

    public List<File> listPolicyDeploymentFailures() {
        File failedPoliciesFolder = this.getFailedPoliciesFolder();
        return failedPoliciesFolder.exists() ? Arrays.asList(this.getFailedPoliciesFolder().listFiles()) : Collections.emptyList();
    }

    public File getPolicyFolder(String policyName) {
        return new File(this.policiesWorkingDir, policyName);
    }
}

