/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.pointcut;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.mule.runtime.http.policy.api.SourcePolicyAwareAttributes;
import org.mule.runtime.policy.api.AttributeAwarePointcut;
import org.mule.runtime.policy.api.PolicyAwareAttributes;
import org.mule.runtime.policy.api.PolicyPointcut;
import org.mule.runtime.policy.api.PolicyPointcutParameters;

public class CompositePointcut
implements AttributeAwarePointcut {
    private final CompositePointcutOperator operator;
    private List<PolicyPointcut> policyPointcuts;

    private CompositePointcut(CompositePointcutOperator operator, List<PolicyPointcut> policyPointcuts) {
        Preconditions.checkNotNull((Object)((Object)operator), (Object)"Composite pointcut operator can not be null");
        Preconditions.checkNotNull(policyPointcuts, (Object)"Composite pointcuts can not be null");
        this.policyPointcuts = policyPointcuts;
        this.operator = operator;
    }

    public static CompositePointcut or(List<PolicyPointcut> pointcuts) {
        return new CompositePointcut(CompositePointcutOperator.OR, pointcuts);
    }

    public static CompositePointcut and(List<PolicyPointcut> pointcuts) {
        return new CompositePointcut(CompositePointcutOperator.AND, pointcuts);
    }

    public static CompositePointcut or(PolicyPointcut left, PolicyPointcut right) {
        return new CompositePointcut(CompositePointcutOperator.OR, Lists.newArrayList((Object[])new PolicyPointcut[]{left, right}));
    }

    public static CompositePointcut and(PolicyPointcut left, PolicyPointcut right) {
        return new CompositePointcut(CompositePointcutOperator.AND, Lists.newArrayList((Object[])new PolicyPointcut[]{left, right}));
    }

    public boolean matches(PolicyPointcutParameters policyPointcutParameters) {
        return this.operator.equals((Object)CompositePointcutOperator.OR) ? this.policyPointcuts.stream().anyMatch(pointcut -> pointcut.matches(policyPointcutParameters)) : this.policyPointcuts.stream().allMatch(pointcut -> pointcut.matches(policyPointcutParameters));
    }

    public PolicyAwareAttributes sourcePolicyAwareAttributes() {
        return this.policyPointcuts.stream().filter(p -> p instanceof AttributeAwarePointcut).map(p -> ((AttributeAwarePointcut)p).sourcePolicyAwareAttributes()).reduce((PolicyAwareAttributes)SourcePolicyAwareAttributes.noAttributes(), PolicyAwareAttributes::merge);
    }

    static enum CompositePointcutOperator {
        OR,
        AND;

    }
}

