/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.engine.queue;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobInstanceAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.BatchStepAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.queue.BatchQueueDelegate;
import com.mulesoft.mule.runtime.module.batch.engine.queue.BatchQueueManager;
import com.mulesoft.mule.runtime.module.batch.engine.transaction.BatchTransactionContext;
import com.mulesoft.mule.runtime.module.batch.internal.BaseBatchProcessingListenerOwner;
import com.mulesoft.mule.runtime.module.batch.internal.engine.queue.SteppingQueueDelegate;
import com.mulesoft.mule.runtime.module.batch.internal.engine.queue.StreamingAggregatorInputQueueDelegate;
import com.mulesoft.mule.runtime.module.batch.internal.engine.queue.StreamingAggregatorOutputQueueDelegate;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.queue.QueueManager;
import org.mule.runtime.core.api.util.queue.QueueSession;
import org.mule.runtime.core.internal.context.DefaultMuleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBatchQueueManager
extends BaseBatchProcessingListenerOwner
implements BatchQueueManager,
Initialisable,
Disposable {
    private static final long DEFAULT_QUEUE_TIMEOUT_MILLIS = 100L;
    private static final Logger logger = LoggerFactory.getLogger(DefaultBatchQueueManager.class);
    private long queueTimeout = 100L;
    @Inject
    @Named(value="kryo.serializer")
    private ObjectSerializer serializer;
    private QueueManager queueManager;
    @Inject
    private MuleContext muleContext;
    private final LoadingCache<BatchJobInstanceAdapter, DelegateBroker> brokers = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<BatchJobInstanceAdapter, DelegateBroker>(){

        public DelegateBroker load(BatchJobInstanceAdapter jobInstance) throws Exception {
            return new DelegateBroker(jobInstance);
        }
    });

    @Override
    public QueueSession newQueueSession() {
        return this.queueManager.getQueueSession();
    }

    @Override
    public BatchQueueDelegate steppingQueue(BatchJobInstanceAdapter jobInstance) {
        return this.getBroker(jobInstance).getSteppingQueueDelegate();
    }

    @Override
    public BatchQueueDelegate streamingAggregatorInputQueue(BatchJobInstanceAdapter jobInstance, BatchStepAdapter step) {
        return this.getBroker(jobInstance).getStreamingAggregatorInputDelegate(step);
    }

    @Override
    public BatchQueueDelegate streamingAggregatorOutputQueue(BatchJobInstanceAdapter jobInstance, BatchStepAdapter step) {
        return this.getBroker(jobInstance).getStreamingAggregatorOutputDelegate(step);
    }

    @Override
    public void disposeQueues(BatchTransactionContext ctx) {
        DelegateBroker broker = (DelegateBroker)this.brokers.asMap().remove(ctx.getJobInstance());
        if (broker != null) {
            broker.dispose(ctx);
        }
    }

    @Override
    public void disposeBroker(BatchJobInstanceAdapter jobInstance) {
        this.brokers.asMap().remove(jobInstance);
    }

    private DelegateBroker getBroker(BatchJobInstanceAdapter jobInstace) {
        return (DelegateBroker)this.brokers.getUnchecked((Object)jobInstace);
    }

    @Override
    public long brokersSize() {
        return this.brokers.size();
    }

    public void initialise() throws InitialisationException {
        if (this.queueManager == null) {
            this.queueManager = ((DefaultMuleContext)this.muleContext).getLocalQueueManager();
        }
    }

    public void dispose() {
        this.brokers.invalidateAll();
    }

    public void setQueueTimeout(long queueTimeout) {
        this.queueTimeout = queueTimeout;
    }

    public void setQueueManager(QueueManager queueManager) {
        this.queueManager = queueManager;
    }

    private class DelegateBroker {
        private final BatchJobInstanceAdapter jobInstance;
        private final BatchQueueDelegate steppingQueueDelegate;
        private final Cache<BatchStepAdapter, BatchQueueDelegate> streamingAggregatorInputDelegates = CacheBuilder.newBuilder().build();
        private final Cache<BatchStepAdapter, BatchQueueDelegate> streamingAggregatorOutputDelegates = CacheBuilder.newBuilder().build();

        private DelegateBroker(BatchJobInstanceAdapter jobInstance) {
            this.jobInstance = jobInstance;
            this.steppingQueueDelegate = new SteppingQueueDelegate(jobInstance, DefaultBatchQueueManager.this.queueManager, DefaultBatchQueueManager.this.queueTimeout, DefaultBatchQueueManager.this.serializer, DefaultBatchQueueManager.this.muleContext, DefaultBatchQueueManager.this.getListeners(jobInstance));
        }

        private BatchQueueDelegate getSteppingQueueDelegate() {
            return this.steppingQueueDelegate;
        }

        private BatchQueueDelegate getStreamingAggregatorInputDelegate(BatchStepAdapter step) {
            return this.doGetStreamingAggregator(this.streamingAggregatorInputDelegates, step, StreamingAggregatorInputQueueDelegate.class);
        }

        private BatchQueueDelegate getStreamingAggregatorOutputDelegate(BatchStepAdapter step) {
            return this.doGetStreamingAggregator(this.streamingAggregatorOutputDelegates, step, StreamingAggregatorOutputQueueDelegate.class);
        }

        private <T extends BatchQueueDelegate> BatchQueueDelegate doGetStreamingAggregator(Cache<BatchStepAdapter, BatchQueueDelegate> cache, BatchStepAdapter step, Class<T> clazz) {
            try {
                return (BatchQueueDelegate)cache.get((Object)step, () -> this.newDelegate(clazz, step));
            }
            catch (ExecutionException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Could not create streaming delegate for step '%s' processing job instance '%s' of job '%s'", step.getName(), this.jobInstance.getId(), this.jobInstance.getOwnerJobName())), (Throwable)e);
            }
        }

        private <T extends BatchQueueDelegate> T newDelegate(Class<T> clazz, BatchStepAdapter step) {
            try {
                return (T)((BatchQueueDelegate)ClassUtils.instantiateClass(clazz, (Object[])new Object[]{this.jobInstance, DefaultBatchQueueManager.this.queueManager, DefaultBatchQueueManager.this.queueTimeout, step, DefaultBatchQueueManager.this.serializer, DefaultBatchQueueManager.this.muleContext}));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Could not instantiate BatchQueueDelegate of class %s. Verify that constructor meets expectation", clazz.getCanonicalName()), e);
            }
        }

        private synchronized void dispose(BatchTransactionContext ctx) {
            this.dispose(this.steppingQueueDelegate, ctx);
            this.dispose(this.streamingAggregatorInputDelegates, ctx);
            this.dispose(this.streamingAggregatorOutputDelegates, ctx);
        }

        private void dispose(Cache<BatchStepAdapter, BatchQueueDelegate> delegates, BatchTransactionContext ctx) {
            for (BatchQueueDelegate delegate : delegates.asMap().values()) {
                this.dispose(delegate, ctx);
            }
            delegates.invalidateAll();
        }

        private void dispose(BatchQueueDelegate delegate, BatchTransactionContext ctx) {
            if (delegate != null) {
                try {
                    delegate.dispose(ctx);
                }
                catch (Exception e) {
                    logger.error(String.format("Exception found trying to dispose queue %s", delegate.getQueueName()), (Throwable)e);
                }
            }
        }
    }
}

