/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal;

import com.mulesoft.mule.runtime.module.batch.api.BatchStep;
import com.mulesoft.mule.runtime.module.batch.api.extension.structure.BatchJobInstance;
import com.mulesoft.mule.runtime.module.batch.engine.BatchEngine;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobInstanceAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.BatchStepAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.history.HistoryExpirationCriteria;
import com.mulesoft.mule.runtime.module.batch.engine.history.HistoryExpirationPolicy;
import com.mulesoft.mule.runtime.module.batch.internal.BatchMessageBlock;
import com.mulesoft.mule.runtime.module.batch.internal.BatchRecordProcessors;
import com.mulesoft.mule.runtime.module.batch.internal.DefaultBatchStep;
import com.mulesoft.mule.runtime.module.batch.privileged.ImmutableBatchJobInstance;
import com.mulesoft.mule.runtime.module.batch.scheduling.BatchJobInstanceSchedulingStrategy;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBatchJob
extends AbstractComponent
implements BatchJobAdapter,
Processor,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBatchJob.class);
    private final int blockSize;
    private final MuleContext muleContext;
    private final String name;
    private String target;
    private String targetValue;
    private String jobInstanceIdExpression = null;
    private List<BatchStepAdapter> steps;
    private int maxFailedRecords = 0;
    private final Map<String, BatchStepAdapter> stepsById = new HashMap<String, BatchStepAdapter>();
    private BatchRecordProcessors recordProcessors;
    private BatchMessageBlock onCompleteBlock;
    private BatchJobInstanceSchedulingStrategy batchJobInstanceSchedulingStrategy;
    private HistoryExpirationPolicy historyExpirationPolicy;
    private int maxConcurrency;
    private Scheduler workScheduler;
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private BatchEngine batchEngine;
    @Inject
    private ExpressionManager expressionManager;

    public DefaultBatchJob(String name, int blockSize, MuleContext muleContext) {
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)name) ? 1 : 0) != 0, (String)"name cannot be blank");
        Preconditions.checkArgument((blockSize >= 1 ? 1 : 0) != 0, (String)"blockSize cannot be lower than 1");
        this.name = name;
        this.blockSize = blockSize;
        this.muleContext = muleContext;
    }

    public void initialise() throws InitialisationException {
        this.batchEngine.registerBatchJob(this);
        this.initExpirationPolicy();
        if (this.onCompleteBlock != null) {
            this.onCompleteBlock.initialise();
        }
        this.initSteps();
    }

    public void start() throws MuleException {
        for (BatchStep batchStep : this.steps) {
            LifecycleUtils.startIfNeeded((Object)batchStep);
        }
        LifecycleUtils.startIfNeeded((Object)((Object)this.onCompleteBlock));
        this.workScheduler = this.schedulerService.ioScheduler(this.muleContext.getSchedulerBaseConfig().withMaxConcurrentTasks(this.getMaxConcurrency()).withName(String.format("batch-job-%s-work-manager", this.getName())));
    }

    public void stop() throws MuleException {
        if (this.workScheduler != null) {
            try {
                this.workScheduler.stop();
            }
            catch (Exception e) {
                LOGGER.error("Could not stop scheduler. Shutdown will continue", (Throwable)e);
            }
        }
        LifecycleUtils.stopIfNeeded((Object)((Object)this.onCompleteBlock));
        for (BatchStep batchStep : this.steps) {
            LifecycleUtils.stopIfNeeded((Object)batchStep);
        }
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded((Object)((Object)this.onCompleteBlock), (Logger)LOGGER);
        this.steps.forEach(step -> LifecycleUtils.disposeIfNeeded((Object)step, (Logger)LOGGER));
        this.workScheduler = null;
    }

    protected void initExpirationPolicy() throws InitialisationException {
        if (this.historyExpirationPolicy == null) {
            this.historyExpirationPolicy = new HistoryExpirationPolicy(new HistoryExpirationCriteria(7L, TimeUnit.DAYS));
        }
    }

    private void initSteps() throws InitialisationException {
        this.steps = this.recordProcessors.getSteps();
        this.validateSteps();
        int stepCount = this.steps.size();
        int i = 0;
        while (i < stepCount) {
            BatchStepAdapter step = this.steps.get(i);
            this.stepsById.put(step.getName(), step);
            if (step instanceof DefaultBatchStep) {
                DefaultBatchStep defaultStep = (DefaultBatchStep)step;
                defaultStep.setJob(this);
                if (++i < stepCount) {
                    defaultStep.setNextStep(this.steps.get(i));
                } else {
                    defaultStep.setLast(true);
                }
            }
            LifecycleUtils.initialiseIfNeeded((Object)step, (MuleContext)this.muleContext);
        }
    }

    private void validateSteps() {
        if (this.steps == null || this.steps.isEmpty()) {
            throw new IllegalArgumentException(String.format("Batch Job %s has to have at least one step", this.getName()));
        }
        TreeSet<String> ids = new TreeSet<String>();
        for (BatchStep batchStep : this.steps) {
            String name = batchStep.getName();
            if (ids.contains(name)) {
                throw new IllegalArgumentException(String.format("Batch job %s already has a step with name '%s. Two steps cannot share the same name", this.getName(), name));
            }
            ids.add(name);
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void submitWork(Runnable before, Runnable work, Runnable after) {
        this.workScheduler.submit(() -> {
            try {
                before.run();
                work.run();
            }
            finally {
                after.run();
            }
        });
    }

    public CoreEvent process(CoreEvent event) throws MuleException {
        BatchJobInstance jobInstance = this.execute(event);
        CoreEvent resultEvent = CoreEvent.builder((CoreEvent)event).addVariable("batchJobInstanceId", (Object)jobInstance.getId()).message(Message.of((Object)jobInstance)).build();
        resultEvent = this.addTargetVariableIfNeeded(resultEvent, event);
        return resultEvent;
    }

    @Override
    public BatchJobInstance execute(CoreEvent event) throws MuleException {
        BatchJobInstanceAdapter jobInstance = this.batchEngine.load(this.batchEngine.createNewJobInstance(this, event), event);
        if (!jobInstance.getStatus().isExecutable()) {
            this.batchEngine.getBatchQueueManager().disposeBroker(jobInstance);
        }
        return new ImmutableBatchJobInstance(jobInstance);
    }

    @Override
    public Optional<Processor> getOnCompleteBlock() {
        return Optional.ofNullable(this.onCompleteBlock);
    }

    public void setOnCompleteBlock(BatchMessageBlock onCompleteBlock) {
        this.onCompleteBlock = onCompleteBlock;
    }

    @Override
    public BatchStepAdapter getStepById(String stepId) {
        BatchStepAdapter step = this.stepsById.get(stepId);
        if (step == null) {
            throw new IllegalArgumentException(String.format("There's no step with id %s in batch job %s", stepId, this.getName()));
        }
        return step;
    }

    @Override
    public List<BatchStep> getSteps() {
        return Collections.unmodifiableList(this.recordProcessors.getSteps());
    }

    @Override
    public BatchEngine getBatchEngine() {
        return this.batchEngine;
    }

    @Override
    public String generateJobInstanceId(CoreEvent event) {
        if (StringUtils.isBlank((CharSequence)this.jobInstanceIdExpression)) {
            return UUID.getUUID();
        }
        Object jobInstanceId = this.expressionManager.evaluate(this.jobInstanceIdExpression, event).getValue();
        if (jobInstanceId == null) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Batch job '%s' contains a %s expression which returned null. Please upgrade the expression to return not null values.", this.getName(), "job-instance-id")));
        }
        if (!(jobInstanceId instanceof String)) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Batch job '%s' contains a %s expression which returned a value of type '%s' but String is expected. Please upgrade your expression.", this.getName(), "job-instance-id", jobInstanceId.getClass().getName())));
        }
        String idString = (String)jobInstanceId;
        if (StringUtils.isBlank((CharSequence)idString)) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Batch job '%s' contains a %s expression which returned a blank String. Please upgrade your expression to return a valid id.", this.getName(), "job-instance-id")));
        }
        return idString;
    }

    public void setBatchEngine(BatchEngine batchEngine) {
        this.batchEngine = batchEngine;
    }

    public void setRecordProcessors(BatchRecordProcessors recordProcessors) {
        this.recordProcessors = recordProcessors;
    }

    @Override
    public int getMaxFailedRecords() {
        return this.maxFailedRecords;
    }

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }

    public void setMaxFailedRecords(int maxFailures) {
        this.maxFailedRecords = maxFailures;
    }

    public ReactiveProcessor.ProcessingType getProcessingType() {
        return ReactiveProcessor.ProcessingType.BLOCKING;
    }

    @Override
    public BatchJobInstanceSchedulingStrategy getBatchJobInstanceSchedulingStrategy() {
        return this.batchJobInstanceSchedulingStrategy;
    }

    public void setBatchJobInstanceSchedulingStrategy(BatchJobInstanceSchedulingStrategy batchJobInstanceSchedulingStrategy) {
        this.batchJobInstanceSchedulingStrategy = batchJobInstanceSchedulingStrategy;
    }

    public void setJobInstanceIdExpression(String jobInstanceIdExpression) {
        this.jobInstanceIdExpression = jobInstanceIdExpression;
    }

    @Override
    public HistoryExpirationPolicy getHistoryExpirationPolicy() {
        return this.historyExpirationPolicy;
    }

    @Override
    public int getMaxConcurrency() {
        return this.maxConcurrency;
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setHistoryExpirationPolicy(HistoryExpirationPolicy historyExpirationPolicy) {
        this.historyExpirationPolicy = historyExpirationPolicy;
    }

    public void setMaxConcurrency(int maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setTargetValue(String targetValue) {
        this.targetValue = targetValue;
    }

    private CoreEvent addTargetVariableIfNeeded(CoreEvent resultEvent, CoreEvent originalEvent) {
        if (StringUtils.isBlank((CharSequence)this.target)) {
            return resultEvent;
        }
        TypedValue result = this.expressionManager.evaluate(this.targetValue, BindingContextUtils.getTargetBindingContext((Message)resultEvent.getMessage()));
        return CoreEvent.builder((CoreEvent)originalEvent).addVariable(this.target, result).build();
    }
}

