/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.propagation.legacy;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.datasenseapi.api.DataSenseElementInfo;
import org.mule.datasenseapi.api.DataSenseInfo;
import org.mule.framework.api.tooling.type.propagation.TypePropagationResult;
import org.mule.framework.api.tooling.type.propagation.TypedChainComponent;
import org.mule.framework.api.tooling.type.propagation.TypedEventField;
import org.mule.framework.internal.tooling.type.propagation.DefaultTypePropagationResult;
import org.mule.framework.internal.tooling.type.propagation.DefaultTypedChainComponent;
import org.mule.framework.internal.tooling.type.propagation.TypedEventFieldBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataTypesDescriptor;
import org.mule.runtime.api.metadata.descriptor.InputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.OutputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.ParameterMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.AstTraversalDirection;

public final class TypePropagationResolverUtils {
    private TypePropagationResolverUtils() {
    }

    private static Optional<TypedEventField> getPayloadField(ComponentAst ast, DataSenseInfo info, Map<String, TypedEventFieldBuilder> calculated, boolean traceDefinitions) {
        Location location = Location.builderFromStringRepresentation((String)ast.getLocation().getLocation()).build();
        Optional<TypedEventField> output = info.getComponentInfoByComponentPath().map(cmpInfo -> (DataSenseElementInfo)cmpInfo.get(location)).flatMap(TypePropagationResolverUtils::fromDataSenseElementInfo);
        return output.map(outputMetadata -> {
            String containerName = ast.getLocation().getRootContainerName();
            return TypePropagationResolverUtils.buildTypedEventField(calculated, containerName, outputMetadata, ast.getLocation(), traceDefinitions);
        });
    }

    private static Optional<MetadataType> fromDataSenseElementInfo(DataSenseElementInfo info) {
        return info.getActualOutput().isPresent() ? info.getActualOutput() : info.getOutput();
    }

    private static TypeMetadataDescriptor typeDescriptorFromOutput(HasOutputModel outputModel) {
        return TypeMetadataDescriptor.builder().withType(outputModel.getOutputAttributes().getType()).dynamic(outputModel.getOutputAttributes().hasDynamicType()).build();
    }

    private static void generateParameterDescriptor(ParameterModel pm, InputMetadataDescriptor.InputMetadataDescriptorBuilder inputBuilder) {
        inputBuilder.withParameter(pm.getName(), ParameterMetadataDescriptor.builder((String)pm.getName()).withType(pm.getType()).dynamic(pm.hasDynamicType()).build());
    }

    private static Optional<ComponentMetadataTypesDescriptor> getMetadataDescriptor(ComponentAst ast, DataSenseInfo info, Optional<ConnectableComponentModel> updatedModel) {
        Reference dynamic = new Reference((Object)false);
        Location location = Location.builderFromStringRepresentation((String)ast.getLocation().getLocation()).build();
        Optional output = info.getComponentInfoByComponentPath().map(cmpInfo -> (DataSenseElementInfo)cmpInfo.get(location)).flatMap(DataSenseElementInfo::getOutput);
        ComponentMetadataTypesDescriptor.ComponentMetadataTypesDescriptorBuilder builder = ComponentMetadataTypesDescriptor.builder();
        InputMetadataDescriptor.InputMetadataDescriptorBuilder inputBuilder = InputMetadataDescriptor.builder();
        OutputMetadataDescriptor.OutputMetadataDescriptorBuilder outputBuilder = OutputMetadataDescriptor.builder();
        ast.getModel(HasOutputModel.class).ifPresent(outputModel -> {
            if (outputModel.getOutput().hasDynamicType() && output.isPresent()) {
                dynamic.set((Object)true);
                outputBuilder.withReturnType(TypeMetadataDescriptor.builder().withType((MetadataType)output.get()).dynamic(outputModel.getOutput().hasDynamicType()).build());
            } else {
                outputBuilder.withReturnType(TypeMetadataDescriptor.builder().withType(outputModel.getOutput().getType()).dynamic(outputModel.getOutput().hasDynamicType()).build());
            }
            if (outputModel.getOutputAttributes().hasDynamicType() && updatedModel.isPresent()) {
                dynamic.set((Object)true);
                outputBuilder.withAttributesType(((ConnectableComponentModel)updatedModel.get()).getOutputAttributes().getType());
            } else {
                outputBuilder.withAttributesType(TypePropagationResolverUtils.typeDescriptorFromOutput(outputModel));
            }
        });
        updatedModel.ifPresent(model -> model.getAllParameterModels().forEach(pm -> {
            TypePropagationResolverUtils.generateParameterDescriptor(pm, inputBuilder);
            if (pm.hasDynamicType()) {
                dynamic.set((Object)true);
            }
        }));
        return (Boolean)dynamic.get() != false ? Optional.of(builder.withOutputMetadataDescriptor(outputBuilder.build()).withInputMetadataDescriptor(inputBuilder.build()).build()) : Optional.empty();
    }

    private static TypedEventField buildTypedEventField(Map<String, TypedEventFieldBuilder> calculated, String name, MetadataType type, ComponentLocation location, boolean traceDefinitions) {
        TypedEventFieldBuilder builder;
        if (calculated.containsKey(name) && calculated.get(name).isType(type)) {
            builder = calculated.get(name);
        } else {
            builder = new TypedEventFieldBuilder();
            if (traceDefinitions) {
                builder.withDeclarationIn(location);
            }
            builder.withMetadataType(type);
            calculated.put(name, builder);
        }
        return builder.build();
    }

    private static Map<String, TypedEventField> getVariables(ComponentAst ast, DataSenseInfo info, Map<String, TypedEventFieldBuilder> calculated, boolean traceDefinitions) {
        Location location = Location.builderFromStringRepresentation((String)ast.getLocation().getLocation()).build();
        Optional<Boolean> input = info.getComponentInfoByComponentPath().map(cmpInfo -> (DataSenseElementInfo)cmpInfo.get(location)).flatMap(DataSenseElementInfo::getIncoming);
        HashMap<String, TypedEventField> vars = new HashMap<String, TypedEventField>();
        if (input.map(in -> !(in instanceof MuleEventMetadataType)).orElse(true).booleanValue()) {
            return vars;
        }
        Collection varsMetadata = ((MuleEventMetadataType)input.get()).getVariables().getFields();
        for (ObjectFieldType varType : varsMetadata) {
            String varName = varType.getKey().getName().toString();
            vars.put(varName, TypePropagationResolverUtils.buildTypedEventField(calculated, varName, varType.getValue(), ast.getLocation(), traceDefinitions));
        }
        return vars;
    }

    public static TypePropagationResult resolve(ComponentAst ast, DataSenseInfo info, Map<ComponentLocation, ConnectableComponentModel> updatedModels, boolean traceDefinitions) {
        HashMap calculated = new HashMap();
        HashMap<ComponentLocation, TypedChainComponent> result = new HashMap<ComponentLocation, TypedChainComponent>();
        ast.recursiveStream(AstTraversalDirection.BOTTOM_UP).forEach(componentAst -> TypePropagationResolverUtils.getPayloadField(componentAst, info, calculated, traceDefinitions).ifPresent(field -> result.put(componentAst.getLocation(), new DefaultTypedChainComponent(componentAst.getLocation(), TypePropagationResolverUtils.getMetadataDescriptor(componentAst, info, Optional.ofNullable(updatedModels.getOrDefault(componentAst.getLocation(), null))), Optional.empty(), (TypedEventField)field, Optional.empty(), null, TypePropagationResolverUtils.getVariables(componentAst, info, calculated, traceDefinitions)))));
        return DefaultTypePropagationResult.success(result);
    }
}

