/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.propagation.legacy;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.datasense.api.metadataprovider.DataSenseMetadataProvider;
import org.mule.framework.api.extension.config.ConfigurationHandler;
import org.mule.framework.api.tooling.MuleToolingFramework;
import org.mule.framework.api.tooling.type.resolution.TypeResolutionSession;
import org.mule.framework.internal.InternalMuleFramework;
import org.mule.framework.internal.tooling.type.propagation.utils.ModelsUtils;
import org.mule.framework.internal.tooling.type.resolution.NullTypeResolutionContext;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataTypesDescriptor;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.module.extension.internal.runtime.resolver.ComponentParameterizationUtils;

public class DietToolingDataSenseMetadataProvider
implements DataSenseMetadataProvider {
    private final InternalMuleFramework muleFramework;
    private final MuleToolingFramework toolingFramework;
    private final Map<ComponentLocation, ConnectableComponentModel> updatedModels;

    public DietToolingDataSenseMetadataProvider(InternalMuleFramework muleFramework, Map<ComponentLocation, ConnectableComponentModel> updatedModels) {
        this.muleFramework = muleFramework;
        this.toolingFramework = muleFramework.getToolingFramework();
        this.updatedModels = updatedModels;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MetadataResult<OperationModel> getOperationMetadata(ComponentAst componentModelAst) {
        Optional model = componentModelAst.getModel(OperationModel.class);
        if (!model.isPresent()) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage(String.format("Component in %s has no OperationModel", componentModelAst.getLocation().getLocation())).withFailureCode(FailureCode.NO_DYNAMIC_METADATA_AVAILABLE).onComponent()});
        }
        try (TypeResolutionSession resolutionSession = this.toolingFramework.createTypeResolutionSession(componentModelAst.getExtensionModel().getName(), (ComponentModel)model.get());){
            Map<String, Object> params = this.getParameters(componentModelAst);
            ComponentParameterization parameterization = ComponentParameterizationUtils.createComponentParameterization((ParameterizedModel)((ParameterizedModel)model.get()), params);
            Optional<ConfigurationHandler> handler = this.getConfigurationHandler(componentModelAst, params);
            MetadataResult result = resolutionSession.resolveComponentTypes(parameterization, handler, NullTypeResolutionContext.getInstance());
            if (result.isSuccess()) {
                OperationModel updatedModel = ModelsUtils.getTypedOperationModel((OperationModel)model.get(), ((ComponentMetadataTypesDescriptor)result.get()).getInputMetadata(), ((ComponentMetadataTypesDescriptor)result.get()).getOutputMetadata(), ((ComponentMetadataTypesDescriptor)result.get()).getOutputAttributesMetadata());
                this.updatedModels.put(componentModelAst.getLocation(), (ConnectableComponentModel)updatedModel);
                MetadataResult metadataResult2 = MetadataResult.success((Object)updatedModel);
                return metadataResult2;
            }
            MetadataResult metadataResult = MetadataResult.failure((List)result.getFailures());
            return metadataResult;
        }
        catch (Exception e) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)e).onComponent()});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MetadataResult<SourceModel> getSourceMetadata(ComponentAst componentModelAst) {
        Optional model = componentModelAst.getModel(SourceModel.class);
        if (!model.isPresent()) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage(String.format("Component at location %s has no SourceModel", componentModelAst.getLocation().getLocation())).withFailureCode(FailureCode.NO_DYNAMIC_METADATA_AVAILABLE).onComponent()});
        }
        try (TypeResolutionSession resolutionSession = this.toolingFramework.createTypeResolutionSession(componentModelAst.getExtensionModel().getName(), (ComponentModel)model.get());){
            Map<String, Object> params = this.getParameters(componentModelAst);
            ComponentParameterization parameterization = ComponentParameterizationUtils.createComponentParameterization((ParameterizedModel)((ParameterizedModel)model.get()), params);
            Optional<ConfigurationHandler> handler = this.getConfigurationHandler(componentModelAst, params);
            MetadataResult result = resolutionSession.resolveComponentTypes(parameterization, handler, NullTypeResolutionContext.getInstance());
            if (result.isSuccess()) {
                SourceModel updatedModel = ModelsUtils.getTypedSourceModel((SourceModel)model.get(), ((ComponentMetadataTypesDescriptor)result.get()).getInputMetadata(), ((ComponentMetadataTypesDescriptor)result.get()).getOutputMetadata(), ((ComponentMetadataTypesDescriptor)result.get()).getOutputAttributesMetadata());
                this.updatedModels.put(componentModelAst.getLocation(), (ConnectableComponentModel)updatedModel);
                MetadataResult metadataResult2 = MetadataResult.success((Object)updatedModel);
                return metadataResult2;
            }
            MetadataResult metadataResult = MetadataResult.failure((List)result.getFailures());
            return metadataResult;
        }
        catch (Exception e) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)e).onComponent()});
        }
    }

    public MetadataResult<MetadataKeysContainer> getMetadataKeys(ComponentAst componentModelAst) {
        return componentModelAst.getModel(OperationModel.class).map(model -> {
            MetadataResult metadataResult;
            block8: {
                TypeResolutionSession resolutionSession = this.toolingFramework.createTypeResolutionSession(componentModelAst.getExtensionModel().getName(), (ComponentModel)model);
                try {
                    Map<String, Object> params = this.getParameters(componentModelAst);
                    ComponentParameterization parameterization = ComponentParameterizationUtils.createComponentParameterization((ParameterizedModel)model, params);
                    metadataResult = resolutionSession.getMetadataKeys(parameterization, this.getConfigurationHandler(componentModelAst, params));
                    if (resolutionSession == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (resolutionSession != null) {
                            try {
                                resolutionSession.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)e).onComponent()});
                    }
                }
                resolutionSession.close();
            }
            return metadataResult;
        }).orElseGet(() -> MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage(String.format("Component at location %s has no OperationModel", componentModelAst.getLocation().getLocation())).withFailureCode(FailureCode.NO_DYNAMIC_METADATA_AVAILABLE).onComponent()}));
    }

    private Map<String, Object> getParameters(ComponentAst componentModelAst) {
        return componentModelAst.getParameters().stream().filter(param -> param.getValue().isRight()).collect(Collectors.toMap(param -> param.getModel().getName(), param -> param.getValue().getRight()));
    }

    private Optional<ConfigurationHandler> getConfigurationHandler(ComponentAst componentAst, Map<String, Object> params) {
        return componentAst.getModel(ComponentModel.class).flatMap(model -> this.muleFramework.getConfigurationHandler((String)params.get("config-ref")));
    }
}

