/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.propagation.cfg;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.mule.framework.internal.tooling.type.propagation.cfg.TypePropagationCFGVisitor;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.runtime.api.component.location.LocationPart;
import org.mule.runtime.api.metadata.RouterOutputMetadataContext;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;
import org.mule.runtime.cfg.api.ChainExecutionPathTreeVisitor;

public class CFGRouterMetadataContext
implements RouterOutputMetadataContext {
    private final ChainExecutionPathTree router;
    private final TypePropagationCFGVisitor propagator;
    private final MetadataType input;
    private final MetadataType inputAttributes;

    public CFGRouterMetadataContext(ChainExecutionPathTree router, TypePropagationCFGVisitor propagator, MetadataType input, MetadataType inputAttributes) {
        this.router = router;
        this.propagator = propagator;
        this.input = input;
        this.inputAttributes = inputAttributes;
    }

    public Map<String, Supplier<MessageMetadataType>> getRouteOutputMessageTypes() {
        HashMap<String, Supplier<MessageMetadataType>> outputs = new HashMap<String, Supplier<MessageMetadataType>>();
        this.router.children().forEach(route -> {
            List parts = route.getComponentAst().getLocation().getParts();
            outputs.put(((LocationPart)parts.get(parts.size() - 1)).getPartPath(), () -> {
                if (this.propagator.innerRouteStarted((ChainExecutionPathTree)route)) {
                    route.accept((ChainExecutionPathTreeVisitor)this.propagator);
                    this.propagator.innerRouteFinished((ChainExecutionPathTree)route);
                }
                Pair<MetadataType, MetadataType> routeResult = this.propagator.getChainResult((ChainExecutionPathTree)route);
                return MessageMetadataType.builder().payload((MetadataType)routeResult.getFirst()).attributes((MetadataType)routeResult.getSecond()).build();
            });
        });
        return outputs;
    }

    public Supplier<MessageMetadataType> getRouterInputMessageType() {
        return () -> MessageMetadataType.builder().payload(this.input).attributes(this.inputAttributes).build();
    }
}

