/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.extension;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.mule.framework.api.extension.command.ComponentCommand;
import org.mule.framework.api.extension.config.ConfigurationHandler;
import org.mule.framework.internal.InternalMuleFramework;
import org.mule.framework.internal.extension.config.InternalConfigurationHandler;
import org.mule.runtime.api.util.DataSize;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.extension.api.client.params.ComponentParameterizer;

public abstract class BaseComponentCommand<T extends ComponentCommand>
implements ComponentCommand<T> {
    protected final InternalMuleFramework muleFramework;
    protected final Map<String, Object> rawParameters = new HashMap<String, Object>();
    protected final Map<Pair<String, String>, Object> groupedParameters = new HashMap<Pair<String, String>, Object>();
    protected String configRef;
    protected String componentName;
    private Consumer<ComponentParameterizer> parameterizerCommand;

    public BaseComponentCommand(InternalMuleFramework muleFramework) {
        this.muleFramework = muleFramework;
        this.parameterizerCommand = this::configureParamsAndConfig;
    }

    public T withConfig(ConfigurationHandler config) {
        if (!this.muleFramework.isRegistered(config)) {
            throw new IllegalArgumentException(String.format("Supplied config '%s' is not registered on this instance", config.getName()));
        }
        this.setConfig(config);
        return (T)this;
    }

    public T withConfig(String configName) {
        this.setConfig(this.muleFramework.getConfigurationHandler(configName).orElseThrow(() -> new IllegalArgumentException(String.format("No config with name '%s' is registered on this instance", configName))));
        return (T)this;
    }

    private void setConfig(ConfigurationHandler config) {
        if (config instanceof InternalConfigurationHandler && ((InternalConfigurationHandler)config).isDisposed()) {
            throw new IllegalArgumentException(String.format("Supplied config '%s' has been disposed", config.getName()));
        }
        this.configRef = config != null ? config.getName() : null;
    }

    public T withParameter(String parameterName, Object value) {
        this.rawParameters.put(parameterName, value);
        return (T)this;
    }

    public T withParameter(String parameterGroup, String parameter, Object value) {
        this.groupedParameters.put((Pair<String, String>)new Pair((Object)parameterGroup, (Object)parameter), value);
        return (T)this;
    }

    public T withSimpleReconnection(int frequency, int maxAttempts) {
        return this.command(p -> p.withSimpleReconnection(frequency, maxAttempts));
    }

    public T reconnectingForever(int frequency) {
        return this.command(p -> p.reconnectingForever(frequency));
    }

    public T withInMemoryRepeatableStreaming(DataSize initialBufferSize, DataSize bufferSizeIncrement, DataSize maxBufferSize) {
        return this.command(p -> p.withInMemoryRepeatableStreaming(initialBufferSize, bufferSizeIncrement, maxBufferSize));
    }

    public T withFileStoreRepeatableStreaming(DataSize maxInMemorySize) {
        return this.command(p -> p.withFileStoreRepeatableStreaming(maxInMemorySize));
    }

    public T withInMemoryRepeatableIterables(int initialBufferSize, int bufferSizeIncrement, int maxBufferSize) {
        return this.command(p -> p.withInMemoryRepeatableIterables(initialBufferSize, bufferSizeIncrement, maxBufferSize));
    }

    public T withFileStoreRepeatableIterables(int maxInMemoryInstances) {
        return this.command(p -> p.withFileStoreRepeatableIterables(maxInMemoryInstances));
    }

    protected T command(Consumer<ComponentParameterizer> command) {
        this.parameterizerCommand = this.parameterizerCommand.andThen(command);
        return (T)this;
    }

    protected void applyCommands(ComponentParameterizer parameterizer) {
        this.parameterizerCommand.accept(parameterizer);
    }

    private void configureParamsAndConfig(ComponentParameterizer parameterizer) {
        this.rawParameters.forEach((arg_0, arg_1) -> ((ComponentParameterizer)parameterizer).withParameter(arg_0, arg_1));
        this.groupedParameters.forEach((pair, value) -> parameterizer.withParameter((String)pair.getFirst(), (String)pair.getSecond(), value));
        if (this.configRef != null) {
            parameterizer.withConfigRef(this.configRef);
        }
    }

    protected T setComponentName(String componentName) {
        this.componentName = componentName;
        return (T)this;
    }
}

