/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.builder.application;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.framework.api.builder.FrameworkApplicationConfigurer;
import org.mule.framework.api.builder.PluginBuilder;
import org.mule.framework.api.dependency.DependencyResolutionException;
import org.mule.framework.api.dependency.DependencyResolver;
import org.mule.framework.internal.util.MuleFrameworkUtils;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleScope;

class DietPluginBuilder
implements PluginBuilder {
    private final FrameworkApplicationConfigurer frameworkApplicationConfigurer;
    private final DependencyResolver dependencyResolver;
    private final BundleDependency pluginDependency;
    private final Map<Pair<String, String>, BundleDependency> additionalDependencies;

    public DietPluginBuilder(FrameworkApplicationConfigurer frameworkApplicationConfigurer, DependencyResolver dependencyResolver, BundleDependency pluginDependency) {
        this.frameworkApplicationConfigurer = frameworkApplicationConfigurer;
        this.dependencyResolver = dependencyResolver;
        this.pluginDependency = pluginDependency;
        this.additionalDependencies = new HashMap<Pair<String, String>, BundleDependency>();
    }

    public PluginBuilder withAdditionalDependency(String groupId, String artifactId, String version) {
        return this.withAdditionalDependency(groupId, artifactId, version, null);
    }

    public PluginBuilder withAdditionalDependency(String groupId, String artifactId, String version, String classifier) {
        try {
            BundleDependency dependency = this.dependencyResolver.resolveFor(new BundleDescriptor.Builder().setGroupId(groupId).setArtifactId(artifactId).setVersion(version).setBaseVersion(version).setType("jar").setClassifier(classifier).build());
            this.addAdditionalDependency(dependency);
        }
        catch (DependencyResolutionException e) {
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    private void addAdditionalDependency(BundleDependency dependency) {
        Pair dependencyId = new Pair((Object)dependency.getDescriptor().getGroupId(), (Object)dependency.getDescriptor().getArtifactId());
        if (this.additionalDependencies.containsKey(dependencyId) && !MuleFrameworkUtils.mustOverrideArtifact(this.additionalDependencies.get(dependencyId).getDescriptor(), dependency.getDescriptor())) {
            return;
        }
        this.additionalDependencies.put((Pair<String, String>)dependencyId, dependency);
        dependency.getTransitiveDependenciesList().stream().filter(transitiveDependency -> BundleScope.COMPILE.equals((Object)transitiveDependency.getScope())).forEach(this::addAdditionalDependency);
    }

    public FrameworkApplicationConfigurer buildPlugin() {
        return this.frameworkApplicationConfigurer;
    }

    public BundleDependency getPluginDependency() {
        return this.pluginDependency;
    }

    public List<BundleDependency> getAdditionalDependencies() {
        return ImmutableList.copyOf(this.additionalDependencies.values());
    }
}

