/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.framework.api.execution.MuleExecutionFramework;
import org.mule.framework.api.extension.config.ConfigurationHandler;
import org.mule.framework.api.extension.config.fluent.ConfigurationCreationCommand;
import org.mule.framework.api.tooling.MuleToolingFramework;
import org.mule.framework.internal.InternalMuleFramework;
import org.mule.framework.internal.builder.application.FrameworkApplication;
import org.mule.framework.internal.builder.artifact.FrameworkDeployableArtifact;
import org.mule.framework.internal.builder.domain.FrameworkDomain;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.api.metadata.MetadataStorage;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.apikit.metadata.api.MetadataService;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.metadata.api.cache.ComponentParameterizationMetadataCacheIdGenerator;
import org.mule.runtime.metadata.api.cache.ConfigurationMetadataCacheIdGenerator;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.AuthorizationCodeOAuthHandler;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials.ClientCredentialsOAuthHandler;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ocs.PlatformManagedOAuthHandler;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.runtime.module.service.api.manager.ServiceManager;

public class DietMuleFrameworkStaticAnalysis
implements InternalMuleFramework {
    private static final String STATIC_ANALYSIS_ONLY_MESSAGE_TEMPLATE = "This Mule Framework is meant for Mule %ss' static analysis only";
    private final FrameworkDeployableArtifact frameworkDeployableArtifact;
    private final Set<ExtensionModel> extensionModels;

    public DietMuleFrameworkStaticAnalysis(FrameworkDeployableArtifact frameworkDeployableArtifact, Set<ExtensionModel> extensionModels) {
        this.frameworkDeployableArtifact = frameworkDeployableArtifact;
        this.extensionModels = extensionModels;
    }

    public Optional<ExtensionModel> getExtensionModel(String name) {
        return this.extensionModels.stream().filter(em -> em.getName().equals(name)).findAny();
    }

    public Set<ExtensionModel> getExtensionModels() {
        return this.extensionModels;
    }

    public Optional<DeployableProjectModel> getDeployableProjectModel() {
        return this.frameworkDeployableArtifact.getDeployableProjectModel();
    }

    public Optional<ArtifactAst> getArtifactAst() {
        return Optional.of(this.frameworkDeployableArtifact.getArtifactAst());
    }

    public Stream<ComponentAst> getConfigsAst() {
        return this.frameworkDeployableArtifact.getConfigurationsAsts().map(Collection::stream).orElse(Stream.empty());
    }

    public ConfigurationHandler createExtensionConfiguration(String extensionName, String configModelName, Consumer<ConfigurationCreationCommand> command) {
        throw new UnsupportedOperationException(String.format(STATIC_ANALYSIS_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    public DslSyntaxResolver getDslSyntaxResolver(ExtensionModel extensionModel) {
        throw new UnsupportedOperationException(String.format(STATIC_ANALYSIS_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()) + "s' static analysis only");
    }

    public MuleToolingFramework getToolingFramework() {
        throw new UnsupportedOperationException(String.format(STATIC_ANALYSIS_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    public MuleExecutionFramework getExecutionFramework() {
        throw new UnsupportedOperationException(String.format(STATIC_ANALYSIS_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T onExecutionClassLoader(Callable<T> task) throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader originalClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this.getExecutionClassLoader());
        try {
            T t = task.call();
            return t;
        }
        finally {
            currentThread.setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExecutionClassLoader(Runnable task) {
        Thread currentThread = Thread.currentThread();
        ClassLoader originalClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this.getExecutionClassLoader());
        try {
            task.run();
        }
        finally {
            currentThread.setContextClassLoader(originalClassLoader);
        }
    }

    public TypedValue evaluateExpression(String expression, BindingContext bindingContext) {
        throw new UnsupportedOperationException(String.format(STATIC_ANALYSIS_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    public void close() throws Exception {
        this.frameworkDeployableArtifact.dispose();
    }

    @Override
    public ReflectionCache getReflectionCache() {
        throw new UnsupportedOperationException(String.format(STATIC_ANALYSIS_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    @Override
    public ConnectionManager getConnectionManager() {
        throw new UnsupportedOperationException(String.format(STATIC_ANALYSIS_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    @Override
    public ExpressionLanguageMetadataService getExpressionLanguageMetadataService() {
        throw new UnsupportedOperationException(String.format(STATIC_ANALYSIS_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    @Override
    public MetadataService getApiKitMetadataService() {
        throw new UnsupportedOperationException(String.format(STATIC_ANALYSIS_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    @Override
    public ExtensionsClient getExtensionsClient() {
        throw new UnsupportedOperationException(String.format(STATIC_ANALYSIS_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    @Override
    public ConfigurationProperties getConfigurationProperties() {
        throw new UnsupportedOperationException(String.format(STATIC_ANALYSIS_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    @Override
    public AuthorizationCodeOAuthHandler getAuthorizationCodeOAuthHandler() {
        throw new UnsupportedOperationException(String.format(STATIC_ANALYSIS_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    @Override
    public ClientCredentialsOAuthHandler getClientCredentialsOAuthHandler() {
        throw new UnsupportedOperationException(String.format(STATIC_ANALYSIS_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    @Override
    public PlatformManagedOAuthHandler getPlatformManagedOAuthHandler() {
        throw new UnsupportedOperationException(String.format(STATIC_ANALYSIS_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    @Override
    public ExpressionManager getExpressionManager() {
        throw new UnsupportedOperationException(String.format(STATIC_ANALYSIS_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    @Override
    public ClassLoader getExecutionClassLoader() {
        return this.frameworkDeployableArtifact.getExecutionClassLoader();
    }

    @Override
    public MuleContext getMuleContext() {
        throw new UnsupportedOperationException(String.format(STATIC_ANALYSIS_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    @Override
    public ServiceManager getServiceManager() {
        throw new UnsupportedOperationException(String.format(STATIC_ANALYSIS_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    @Override
    public Registry getRegistry() {
        throw new UnsupportedOperationException(String.format(STATIC_ANALYSIS_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    @Override
    public MetadataStorage getMetadataStorage() {
        throw new UnsupportedOperationException(String.format(STATIC_ANALYSIS_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    @Override
    public ComponentParameterizationMetadataCacheIdGenerator getIdGenerator() {
        throw new UnsupportedOperationException(String.format(STATIC_ANALYSIS_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    @Override
    public ConfigurationMetadataCacheIdGenerator getConfigIdGenerator() {
        throw new UnsupportedOperationException(String.format(STATIC_ANALYSIS_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    @Override
    public boolean isRegistered(ConfigurationHandler configurationHandler) {
        throw new UnsupportedOperationException(String.format(STATIC_ANALYSIS_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    @Override
    public FrameworkDeployableArtifact getFrameworkDeployableArtifact() {
        return this.frameworkDeployableArtifact;
    }

    @Override
    public Collection<ComponentAst> getConfigurations() {
        return this.getConfigsAst().collect(Collectors.toList());
    }

    @Override
    public Optional<ConfigurationHandler> getConfigurationHandler(String name) {
        throw new UnsupportedOperationException(String.format(STATIC_ANALYSIS_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    @Override
    public void start() throws MuleException {
        throw new UnsupportedOperationException(String.format(STATIC_ANALYSIS_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    @Override
    public void assertStarted() throws IllegalStateException {
        throw new UnsupportedOperationException(String.format(STATIC_ANALYSIS_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    private String getDeployableArtifactType() {
        if (this.frameworkDeployableArtifact instanceof FrameworkApplication) {
            return "application";
        }
        if (this.frameworkDeployableArtifact instanceof FrameworkDomain) {
            return "domain";
        }
        return "deployable artifact";
    }
}

