/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.config.bootstrap;

import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.DataTypeParamsBuilder;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.config.bootstrap.BootstrapServiceDiscoverer;
import org.mule.runtime.core.api.config.builders.RegistryBootstrap;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.transformer.DiscoverableTransformer;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.config.bootstrap.AbstractRegistryBootstrap;
import org.mule.runtime.core.internal.config.bootstrap.ObjectBootstrapProperty;
import org.mule.runtime.core.internal.config.bootstrap.TransformerBootstrapProperty;
import org.mule.runtime.core.privileged.registry.RegistrationException;

public class SimpleRegistryBootstrap
extends AbstractRegistryBootstrap {
    private final RegistryBootstrap.Registrer registrer;

    public SimpleRegistryBootstrap(ArtifactType supportedArtifactType, BootstrapServiceDiscoverer bootstrapServiceDiscoverer, RegistryBootstrap.Registrer registrer) {
        super(supportedArtifactType, bootstrapServiceDiscoverer, (String k) -> true);
        this.registrer = registrer;
    }

    @Override
    protected void doRegisterTransformer(TransformerBootstrapProperty bootstrapProperty, Class<?> returnClass, Class<? extends Transformer> transformerClass) throws Exception {
        Transformer trans = ClassUtils.instantiateClass(transformerClass, new Object[0]);
        if (!(trans instanceof DiscoverableTransformer)) {
            throw new RegistrationException(CoreMessages.transformerNotImplementDiscoverable(trans));
        }
        if (returnClass != null) {
            DataTypeParamsBuilder builder = DataType.builder().type(returnClass);
            if (StringUtils.isNotEmpty((CharSequence)bootstrapProperty.getMimeType())) {
                builder = builder.mediaType(bootstrapProperty.getMimeType());
            }
            trans.setReturnDataType(builder.build());
        }
        if (bootstrapProperty.getName() != null) {
            trans.setName(bootstrapProperty.getName());
        } else {
            trans.setName("_" + trans.getName());
        }
        this.registrer.register(trans.getName(), trans);
    }

    @Override
    protected void doRegisterObject(ObjectBootstrapProperty bootstrapProperty) throws Exception {
        this.registrer.register(bootstrapProperty.getKey(), bootstrapProperty.getService().instantiateClass(bootstrapProperty.getClassName(), new Object[0]));
    }
}

