/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance.impl;

import com.hazelcast.cluster.Cluster;
import com.hazelcast.collection.IList;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.impl.executejar.ExecuteJobParameters;
import com.hazelcast.jet.JetCacheManager;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.JetService;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.Observable;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.impl.AbstractJetInstance;
import com.hazelcast.jet.impl.operation.GetJobIdsOperation;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.IMap;
import com.hazelcast.replicatedmap.ReplicatedMap;
import com.hazelcast.topic.ITopic;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public abstract class BootstrappedJetProxy<M>
extends AbstractJetInstance<M> {
    private static final ILogger LOGGER = Logger.getLogger(BootstrappedJetProxy.class);
    private final AbstractJetInstance<M> jetInstance;

    protected BootstrappedJetProxy(@Nonnull JetService jetService) {
        super(((AbstractJetInstance)jetService).getHazelcastInstance());
        this.jetInstance = (AbstractJetInstance)jetService;
    }

    public abstract boolean hasExecuteJobParameters();

    public abstract ExecuteJobParameters getExecuteJobParameters();

    public abstract void setExecuteJobParameters(ExecuteJobParameters var1);

    public void removeExecuteJobParameters() {
    }

    @Override
    @Nonnull
    public String getName() {
        return this.jetInstance.getName();
    }

    @Override
    @Nonnull
    public HazelcastInstance getHazelcastInstance() {
        return this.jetInstance.getHazelcastInstance();
    }

    @Override
    @Nonnull
    public Cluster getCluster() {
        return this.jetInstance.getCluster();
    }

    @Override
    @Nonnull
    public JetConfig getConfig() {
        return this.jetInstance.getConfig();
    }

    @Override
    @Nonnull
    public Job newJob(@Nonnull Pipeline pipeline, @Nonnull JobConfig config) {
        this.updateJobConfig(config);
        Job job = this.jetInstance.newJob(pipeline, config);
        this.addToSubmittedJobs(job);
        return job;
    }

    @Override
    @Nonnull
    public Job newJob(@Nonnull DAG dag, @Nonnull JobConfig config) {
        this.updateJobConfig(config);
        Job job = this.jetInstance.newJob(dag, config);
        this.addToSubmittedJobs(job);
        return job;
    }

    @Override
    @Nonnull
    public Job newJobIfAbsent(@Nonnull Pipeline pipeline, @Nonnull JobConfig config) {
        this.updateJobConfig(config);
        Job job = this.jetInstance.newJobIfAbsent(pipeline, config);
        this.addToSubmittedJobs(job);
        return job;
    }

    @Override
    @Nonnull
    public Job newJobIfAbsent(@Nonnull DAG dag, @Nonnull JobConfig config) {
        this.updateJobConfig(config);
        Job job = this.jetInstance.newJobIfAbsent(dag, config);
        this.addToSubmittedJobs(job);
        return job;
    }

    @Override
    @Nonnull
    public List<Job> getJobs(@Nonnull String name) {
        return this.jetInstance.getJobs(name);
    }

    @Override
    @Nonnull
    public <K, V> IMap<K, V> getMap(@Nonnull String name) {
        return this.jetInstance.getMap(name);
    }

    @Override
    @Nonnull
    public <K, V> ReplicatedMap<K, V> getReplicatedMap(@Nonnull String name) {
        return this.jetInstance.getReplicatedMap(name);
    }

    @Override
    @Nonnull
    public JetCacheManager getCacheManager() {
        return this.jetInstance.getCacheManager();
    }

    @Override
    @Nonnull
    public <E> IList<E> getList(@Nonnull String name) {
        return this.jetInstance.getList(name);
    }

    @Override
    @Nonnull
    public <T> ITopic<T> getReliableTopic(@Nonnull String name) {
        return this.jetInstance.getReliableTopic(name);
    }

    @Override
    @Nonnull
    public <T> Observable<T> getObservable(@Nonnull String name) {
        return this.jetInstance.getObservable(name);
    }

    @Override
    public void shutdown() {
        this.jetInstance.shutdown();
    }

    @Override
    public boolean existsDistributedObject(@Nonnull String serviceName, @Nonnull String objectName) {
        return this.jetInstance.existsDistributedObject(serviceName, objectName);
    }

    @Override
    public ILogger getLogger() {
        return this.jetInstance.getLogger();
    }

    @Override
    public Job newJobProxy(long jobId, M lightJobCoordinator) {
        return this.jetInstance.newJobProxy(jobId, lightJobCoordinator);
    }

    @Override
    public Job newJobProxy(long jobId, boolean isLightJob, @Nonnull Object jobDefinition, @Nonnull JobConfig config) {
        return this.jetInstance.newJobProxy(jobId, isLightJob, jobDefinition, config);
    }

    @Override
    public M getMasterId() {
        return this.jetInstance.getMasterId();
    }

    @Override
    public Map<M, GetJobIdsOperation.GetJobIdsResult> getJobsInt(String onlyName, Long onlyJobId) {
        return this.jetInstance.getJobsInt(onlyName, onlyJobId);
    }

    private void addToSubmittedJobs(@Nonnull Job job) {
        if (this.hasExecuteJobParameters()) {
            ExecuteJobParameters executeJobParameters = this.getExecuteJobParameters();
            executeJobParameters.addSubmittedJob(job);
        }
    }

    private void updateJobConfig(JobConfig jobConfig) {
        if (this.hasExecuteJobParameters()) {
            ExecuteJobParameters jobParameters = this.getExecuteJobParameters();
            if (jobParameters.hasJarPath()) {
                jobConfig.addJar(jobParameters.getJarPath());
                if (jobParameters.hasSnapshotName()) {
                    jobConfig.setInitialSnapshotName(jobParameters.getSnapshotName());
                }
                if (jobParameters.hasJobName()) {
                    jobConfig.setName(jobParameters.getJobName());
                }
            } else {
                String message = "The jet job has been started from a thread that is different from the one that called the main method. \nThe job could not be found in the ThreadLocal and the job will not start.\nIf you still want to start job in a different thread, then you need to set the parameters of the JobConfig in that thread\nJobConfig\n  .addJar(...)\n  .setInitialSnapshotName(...)\n  .setName(...); ";
                LOGGER.severe(message);
                throw new JetException(message);
            }
        }
    }
}

