/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services;

import com.mulesoft.agent.exception.AgentEnableOperationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OnOffSwitch {
    private static final Logger LOGGER = LogManager.getLogger(OnOffSwitch.class);
    private boolean enabled = true;
    private OnOffSwitchEnabler enablerMethod;
    private OnOffSwitchDisabler disablerMethod;

    public static OnOffSwitch newNullSwitch(boolean enableByDefault) {
        OnOffSwitch nullSwitch = new OnOffSwitch(enableByDefault, new OnOffSwitchEnabler(){

            @Override
            public void enable() throws AgentEnableOperationException {
            }
        }, new OnOffSwitchDisabler(){

            @Override
            public void disable() throws AgentEnableOperationException {
            }
        });
        return nullSwitch;
    }

    public OnOffSwitch(OnOffSwitchEnabler enablerMethod, OnOffSwitchDisabler disablerMethod) {
        this.enablerMethod = enablerMethod;
        this.disablerMethod = disablerMethod;
    }

    public OnOffSwitch(boolean initialState, OnOffSwitchEnabler enablerMethod, OnOffSwitchDisabler disablerMethod) {
        this.enablerMethod = enablerMethod;
        this.disablerMethod = disablerMethod;
        this.enabled = initialState;
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void switchTo(boolean state) throws AgentEnableOperationException {
        if (this.enabled && !state) {
            try {
                this.disablerMethod.disable();
                this.enabled = false;
            }
            catch (AgentEnableOperationException e) {
                LOGGER.error("The Application Service could not be disabled", (Throwable)e);
                throw e;
            }
        }
        if (!this.enabled && state) {
            try {
                this.enablerMethod.enable();
                this.enabled = true;
            }
            catch (AgentEnableOperationException e) {
                LOGGER.error("The Application Service could not be enabled", (Throwable)e);
                throw e;
            }
        }
    }

    public static interface OnOffSwitchDisabler {
        public void disable() throws AgentEnableOperationException;
    }

    public static interface OnOffSwitchEnabler {
        public void enable() throws AgentEnableOperationException;
    }
}

