/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.external.handlers.healthcheck;

import com.google.inject.Inject;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.exception.ApiHealthCheckNotReadyException;
import com.mulesoft.agent.exception.ApplicationNotStartedException;
import com.mulesoft.agent.exception.NoSuchApplicationException;
import com.mulesoft.agent.external.handlers.ConfigurableExternalHandler;
import com.mulesoft.agent.services.HealthCheckService;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.sisu.Nullable;

@Named(value="healthcheck.request.handler")
@Path(value="healthcheck")
@Singleton
public class HealthCheckRequestHandler
extends ConfigurableExternalHandler {
    @Inject
    @Nullable
    private HealthCheckService healthCheckService;

    public void enable(boolean state) throws AgentEnableOperationException {
        this.enabledSwitch.switchTo(state);
    }

    public boolean isEnabled() {
        return this.enabledSwitch.isEnabled();
    }

    @GET
    @Path(value="applications/{applicationName}/ready")
    @Produces(value={"text/plain"})
    public Response readiness(@PathParam(value="applicationName") String applicationName) {
        if (this.healthCheckService == null) {
            return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).entity((Object)"").build();
        }
        try {
            Optional body = this.healthCheckService.isReady(applicationName);
            return Response.ok().entity(body.isPresent() ? body.get() : null).build();
        }
        catch (NoSuchApplicationException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"").build();
        }
        catch (ApplicationNotStartedException e) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)e.getMessage()).build();
        }
        catch (ApiHealthCheckNotReadyException e) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="applications/{applicationName}/api/{apiId}/ready")
    @Produces(value={"text/plain"})
    public Response apiReadiness(@PathParam(value="applicationName") String applicationName, @PathParam(value="apiId") Long apiId) {
        if (this.healthCheckService == null) {
            return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).entity((Object)"").build();
        }
        try {
            this.healthCheckService.isReady(applicationName, apiId);
            return Response.ok().build();
        }
        catch (NoSuchApplicationException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"").build();
        }
        catch (ApplicationNotStartedException e) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)e.getMessage()).build();
        }
        catch (ApiHealthCheckNotReadyException e) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)e.getMessage()).build();
        }
    }
}

