/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.context;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.core.internal.management.stats.FlowClassifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowClassifierFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowClassifierFactory.class);
    private static final String APIKIT_EXTENSION_NAME = "APIKit";
    private static final String SOAPKIT_EXTENSION = "APIKit for SOAP";
    private static final String KIT_CONFIG_NAME = "config";
    private static final String APIKIT_FLOW_MAPPINGS_PARAM_NAME = "flowMappings";
    private static final String APIKIT_FLOW_REF_PARAM_GROUP_NAME = "FlowMapping";
    private static final String APIKIT_FLOW_REF_PARAM_NAME = "flow-ref";
    private static final String ANONYMOUS_ID = "ANONYMOUS";
    private final Set<String> apiKitConfigNames;
    private final Set<String> soapKitConfigNames;
    private final Set<String> apiKitMappedFlows;

    public FlowClassifierFactory(ArtifactAst artifactAst) {
        List<ComponentAst> allApiKitConfigs = FlowClassifierFactory.getAllConfigs(artifactAst, APIKIT_EXTENSION_NAME);
        this.apiKitConfigNames = FlowClassifierFactory.getNamesFromConfigs(allApiKitConfigs.stream());
        this.apiKitMappedFlows = FlowClassifierFactory.getFlowMappingsFromConfigs(allApiKitConfigs.stream());
        List<ComponentAst> allSoapKitConfigs = FlowClassifierFactory.getAllConfigs(artifactAst, SOAPKIT_EXTENSION);
        this.soapKitConfigNames = FlowClassifierFactory.getNamesFromConfigs(allSoapKitConfigs.stream());
    }

    private static List<ComponentAst> getAllConfigs(ArtifactAst artifactAst, String extensionName) {
        Stream topLevelsFromParent = artifactAst.getParent().map(ArtifactAst::topLevelComponentsStream).orElse(Stream.empty());
        return Stream.concat(artifactAst.topLevelComponentsStream(), topLevelsFromParent).filter(c -> FlowClassifierFactory.componentIsConfigOf(c, extensionName)).toList();
    }

    private static boolean componentIsConfigOf(ComponentAst componentAst, String extensionName) {
        return TypedComponentIdentifier.ComponentType.CONFIG.equals((Object)componentAst.getComponentType()) && componentAst.getExtensionModel().getName().equals(extensionName) && componentAst.getModel(ConfigurationModel.class).map(NamedObject::getName).filter(KIT_CONFIG_NAME::equals).isPresent();
    }

    private static Set<String> getNamesFromConfigs(Stream<ComponentAst> configs) {
        return configs.filter(c -> c.getComponentId().isPresent()).map(c -> (String)c.getComponentId().get()).collect(Collectors.toSet());
    }

    private static Set<String> getFlowMappingsFromConfigs(Stream<ComponentAst> configs) {
        return configs.map(FlowClassifierFactory::getFlowMappings).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static Set<String> getFlowMappings(ComponentAst apiKitConfig) {
        ComponentParameterAst flowMappingsParameter = apiKitConfig.getParameter("General", APIKIT_FLOW_MAPPINGS_PARAM_NAME);
        if (flowMappingsParameter == null) {
            LOGGER.warn("Component `{}` is a config from `{}` but has no flow-mappings parameter, the model must have changed incompatibly", (Object)apiKitConfig.getComponentId().orElse(ANONYMOUS_ID), (Object)apiKitConfig.getExtensionModel().getName());
            return Collections.emptySet();
        }
        HashSet<String> flowMappings = new HashSet<String>();
        Object flowMappingsValue = flowMappingsParameter.getValue().getRight();
        if (flowMappingsValue instanceof Iterable) {
            Iterable flowMappingsList = (Iterable)flowMappingsValue;
            for (Object flowMapping : flowMappingsList) {
                if (flowMapping instanceof ComponentAst) {
                    ComponentAst flowMappingComp = (ComponentAst)flowMapping;
                    ComponentParameterAst flowMappingParameter = flowMappingComp.getParameter(APIKIT_FLOW_REF_PARAM_GROUP_NAME, APIKIT_FLOW_REF_PARAM_NAME);
                    Object flowRefValue = flowMappingParameter.getValue().getRight();
                    if (flowRefValue instanceof String) {
                        String stringValue = (String)flowRefValue;
                        flowMappings.add(stringValue);
                        continue;
                    }
                    if (flowRefValue != null) {
                        LOGGER.warn("Component `{}` has a flow-mapping with a flow-ref that is not a String value, the model `{}` must have changed incompatibly", (Object)apiKitConfig.getComponentId().orElse(ANONYMOUS_ID), (Object)apiKitConfig.getExtensionModel().getName());
                        continue;
                    }
                    LOGGER.warn("Component `{}` has a flow-mapping with no flow-ref which is supposed to be a required parameter, the model `{}` must have changed incompatibly", (Object)apiKitConfig.getComponentId().orElse(ANONYMOUS_ID), (Object)apiKitConfig.getExtensionModel().getName());
                    continue;
                }
                LOGGER.warn("Component `{}` has a flow-mapping that is not of the expected type, the model `{}` must have changed incompatibly", (Object)apiKitConfig.getComponentId().orElse(ANONYMOUS_ID), (Object)apiKitConfig.getExtensionModel().getName());
            }
        } else if (flowMappingsValue != null) {
            LOGGER.warn("Component `{}` has flow mappings but they are not iterable, the model `{}` must have changed incompatibly", (Object)apiKitConfig.getComponentId().orElse(ANONYMOUS_ID), (Object)apiKitConfig.getExtensionModel().getName());
        }
        return flowMappings;
    }

    public FlowClassifier create() {
        return new DefaultFlowClassifier(this.apiKitConfigNames, this.soapKitConfigNames, this.apiKitMappedFlows);
    }

    private static class DefaultFlowClassifier
    implements FlowClassifier {
        private final Set<String> apiKitConfigNames;
        private final Set<String> soapKitConfigNames;
        private final Set<String> mappedApiKitFlows;

        private DefaultFlowClassifier(Set<String> apiKitConfigNames, Set<String> soapKitConfigNames, Set<String> mappedApiKitFlows) {
            this.apiKitConfigNames = apiKitConfigNames;
            this.soapKitConfigNames = soapKitConfigNames;
            this.mappedApiKitFlows = mappedApiKitFlows;
        }

        public FlowClassifier.FlowType getFlowType(String flowName) {
            if (this.mappedApiKitFlows.contains(flowName)) {
                return FlowClassifier.FlowType.APIKIT;
            }
            Optional<String> candidateKitConfigName = this.tryExtractConfigNameFromFlowName(flowName);
            if (candidateKitConfigName.isEmpty()) {
                return FlowClassifier.FlowType.GENERIC;
            }
            String kitConfigName = candidateKitConfigName.get();
            return kitConfigName.startsWith("\\") ? (this.soapKitConfigNames.contains(kitConfigName.substring(1)) ? FlowClassifier.FlowType.SOAPKIT : FlowClassifier.FlowType.GENERIC) : (this.apiKitConfigNames.contains(kitConfigName) ? FlowClassifier.FlowType.APIKIT : FlowClassifier.FlowType.GENERIC);
        }

        private Optional<String> tryExtractConfigNameFromFlowName(String flowName) {
            int posFound = flowName.lastIndexOf(":");
            if (posFound == -1) {
                return Optional.empty();
            }
            return Optional.of(flowName.substring(posFound + 1));
        }
    }
}

