/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.store;

import com.mulesoft.mule.runtime.gw.api.folders.PolicyFolders;
import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.policies.template.exception.PolicyTemplateAssetException;
import com.mulesoft.mule.runtime.gw.policies.template.provider.PolicyTemplateAssets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;

public class PolicyTemplateStore {
    public static final Pattern POLICY_TEMPLATE_REGEX_PATTERN = Pattern.compile("(.*)-mule-policy.jar");
    public static final String POLICY_TEMPLATE_PATTERN = "%s-mule-policy.jar";
    public static final String POLICY_TEMPLATE_LIGHT_PATTERN = "%s-mule-policy-light-package.jar";
    public static final String POLICY_YAML_PATTERN = "%s.yaml";
    private final File templatesFolder = PolicyFolders.getPolicyTemplatesFolder();
    private final File templatesTempFolder = PolicyFolders.getPolicyTemplatesTempFolder();

    public void storeYaml(PolicyTemplateKey templateKey, InputStream yaml) {
        this.storeStream(yaml, this.getYamlFile(templateKey.getName()));
    }

    public void storeJar(PolicyTemplateKey templateKey, InputStream jar) {
        this.storeStream(jar, this.getJarFile(templateKey.getName()));
    }

    public void storeInternalJar(PolicyTemplateKey templateKey, InputStream jar) {
        this.storeStream(jar, this.getInternalJarFile(templateKey.getName()));
    }

    public PolicyTemplateAssets getInternalTemplateAssets(PolicyTemplateKey templateKey) {
        String templateName = templateKey.getName();
        File templateFile = this.getInternalJarFile(templateName);
        File templateExplodedFolder = this.getTemplateExplodedFolder(templateName);
        return new PolicyTemplateAssets(templateName, templateFile, templateExplodedFolder);
    }

    public PolicyTemplateAssets getTemplateAssets(PolicyTemplateKey templateKey) {
        String templateName = templateKey.getName();
        File templateFile = this.getJarFile(templateName);
        File yamlSpecFile = this.getYamlFile(templateName);
        File templateExplodedFolder = this.getTemplateExplodedFolder(templateName);
        return new PolicyTemplateAssets(templateName, templateFile, yamlSpecFile, templateExplodedFolder);
    }

    public List<PolicyTemplateAssets> getAllTemplateAssets() {
        Stream<String> templateNames = FileUtils.listFiles((File)this.templatesFolder, (IOFileFilter)new RegexFileFilter(POLICY_TEMPLATE_REGEX_PATTERN), null).stream().map(file -> this.toTemplateName(file.getName())).filter(Objects::nonNull);
        if (this.templatesTempFolder.exists()) {
            Stream<String> explodedTemplateNames = Arrays.stream(this.templatesTempFolder.listFiles(File::isDirectory)).map(File::getName);
            templateNames = Stream.concat(templateNames, explodedTemplateNames).distinct();
        }
        return templateNames.map(templateName -> new PolicyTemplateAssets((String)templateName, this.getJarFile((String)templateName), this.getYamlFile((String)templateName), this.getTemplateExplodedFolder((String)templateName))).collect(Collectors.toList());
    }

    private String toTemplateName(String name) {
        Matcher matcher = POLICY_TEMPLATE_REGEX_PATTERN.matcher(name);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    private File getYamlFile(String templateName) {
        return new File(this.templatesFolder, String.format(POLICY_YAML_PATTERN, templateName));
    }

    private File getJarFile(String templateName) {
        return new File(this.templatesFolder, String.format(POLICY_TEMPLATE_PATTERN, templateName));
    }

    private File getInternalJarFile(String templateName) {
        return new File(this.templatesTempFolder, String.format(POLICY_TEMPLATE_PATTERN, templateName));
    }

    private File getTemplateExplodedFolder(String templateName) {
        return new File(this.templatesTempFolder, templateName);
    }

    private void storeStream(InputStream source, File target) {
        try {
            FileUtils.copyInputStreamToFile((InputStream)source, (File)target);
        }
        catch (IOException e) {
            throw new PolicyTemplateAssetException("Unexpected error storing file " + String.valueOf(target), e);
        }
    }
}

