/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.service;

import com.mulesoft.mule.runtime.gw.deployment.api.ApiService;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.service.MultiplexingPolicyDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentTracker;
import com.mulesoft.mule.runtime.gw.policies.service.TransactionalPolicyDeploymentService;
import java.util.function.Consumer;

public class DefaultMultiplexingPolicyDeploymentService
implements MultiplexingPolicyDeploymentService {
    private final ApiService apiService;
    private final TransactionalPolicyDeploymentService policyDeployer;
    private final PolicyDeploymentTracker policyDeploymentTracker;

    public DefaultMultiplexingPolicyDeploymentService(ApiService apiService, PolicyDeploymentTracker policyDeploymentTracker, TransactionalPolicyDeploymentService policyDeployer) {
        this.apiService = apiService;
        this.policyDeploymentTracker = policyDeploymentTracker;
        this.policyDeployer = policyDeployer;
    }

    @Override
    public void newPolicy(PolicyDefinition policy) {
        this.forAllApis(policy, api -> this.policyDeployer.deploy(policy, (Api)api));
    }

    @Override
    public void updatePolicy(PolicyDefinition oldPolicy, PolicyDefinition updatedPolicy) {
        this.forAllApis(updatedPolicy, api -> this.policyDeployer.update(oldPolicy, updatedPolicy, (Api)api));
    }

    @Override
    public void revertPolicy(PolicyDefinition policy) {
        this.forAllApis(policy, api -> this.policyDeployer.revertPolicy(policy, (Api)api));
    }

    @Override
    public void reorderPolicy(PolicyDefinition oldPolicy, PolicyDefinition reorderedPolicy) {
        this.forAllApis(reorderedPolicy, api -> this.policyDeployer.updateOrder(oldPolicy, reorderedPolicy, (Api)api));
    }

    @Override
    public void removePolicy(PolicyDefinition policy) {
        this.forAllApis(policy, api -> this.policyDeployer.undeploy(policy, (Api)api));
    }

    @Override
    public void removePolicyById(String policyId) {
        this.policyDeploymentTracker.findById(policyId).ifPresent(this::removePolicy);
    }

    private void forAllApis(PolicyDefinition policyDefinition, Consumer<Api> consumer) {
        policyDefinition.getApiKeys().forEach(key -> this.apiService.get(key).ifPresent(consumer));
    }
}

