/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.serialization;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.serialization.PointcutsDto;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class PolicyDefinitionDto {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="version")
    private String version;
    @JsonProperty(value="template")
    private PolicyTemplateKeyDTO templateKey;
    @JsonProperty(value="api")
    private List<APIKeyDTO> apis;
    @JsonProperty(value="online")
    private boolean online;
    @JsonProperty(value="order")
    private int order;
    @JsonProperty(value="pointcuts")
    private PointcutsDto pointcuts;
    @JsonProperty(value="configurationVersion")
    private String configurationVersion;
    @JsonProperty(value="configuration")
    private Map<String, Object> configuration;

    public static PolicyDefinitionDto from(PolicyDefinition policyDefinition) {
        PolicyDefinitionDto dto = new PolicyDefinitionDto();
        dto.id = policyDefinition.getId();
        dto.version = policyDefinition.getVersion();
        dto.templateKey = new PolicyTemplateKeyDTO(policyDefinition.getTemplateKey());
        dto.apis = policyDefinition.getApiKeys().stream().map(APIKeyDTO::new).collect(Collectors.toList());
        dto.online = policyDefinition.isOnline();
        dto.order = policyDefinition.getOrder();
        if (!policyDefinition.getHttpResourcePointcuts().isEmpty()) {
            dto.pointcuts = PointcutsDto.from(policyDefinition.getHttpResourcePointcuts());
        }
        PolicyConfiguration config = policyDefinition.getConfigurationData();
        dto.configurationVersion = Optional.ofNullable(config.getConfigurationVersion()).orElse("");
        dto.configuration = config.getConfiguration();
        return dto;
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public PolicyTemplateKeyDTO getTemplateKey() {
        return this.templateKey;
    }

    public int getOrder() {
        return this.order;
    }

    public String getConfigurationVersion() {
        return StringUtils.trimToNull((String)this.configurationVersion);
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public PointcutsDto getPointcuts() {
        return this.pointcuts;
    }

    public boolean getOnline() {
        return this.online;
    }

    public List<APIKeyDTO> getApis() {
        return this.apis;
    }

    static class PolicyTemplateKeyDTO {
        @JsonProperty(value="groupId")
        private String groupId;
        @JsonProperty(value="assetId")
        private String assetId;
        @JsonProperty(value="version")
        private String version;

        public PolicyTemplateKeyDTO() {
        }

        public PolicyTemplateKeyDTO(PolicyTemplateKey key) {
            this.assetId = key.getAssetId();
            this.groupId = key.getGroupId();
            this.version = key.getVersion();
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getAssetId() {
            return this.assetId;
        }

        public String getVersion() {
            return this.version;
        }
    }

    static class APIKeyDTO {
        @JsonProperty(value="id")
        private Long id;

        public APIKeyDTO() {
        }

        public APIKeyDTO(ApiKey apiKey) {
            this.id = apiKey.id();
        }

        public Long getId() {
            return this.id;
        }
    }
}

