/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.backoff.configuration;

import com.mulesoft.anypoint.backoff.function.BoundedExponentialFunction;
import com.mulesoft.anypoint.backoff.function.Round;
import com.mulesoft.anypoint.backoff.function.dispersion.RangeDispersant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

public class BackoffConfiguration {
    public static final double DEFAULT_BACKOFF_BASE = 2.5;
    public static final double DEFAULT_BACKOFF_MULTIPLIER = 14.0;
    public static final double DEFAULT_BACKOFF_DISPERSION = 0.6;
    public static final int DEFAULT_BACKOFF_STEPS = 5;
    public static final double DEFAULT_BACKON_BASE = 2.5;
    public static final double DEFAULT_BACKON_MULTIPLIER = 14.0;
    public static final double DEFAULT_BACKON_DISPERSION = 0.3;
    public static final int DEFAULT_BACKON_STEPS = 3;
    public static final double DEFAULT_FAILURE_PERCENTAGE = 100.0;
    public static final List<Integer> DEFAULT_OUTAGE_STATUS_CODES = Arrays.asList(400, 401, 403, 405, 429, 502, 503);
    private final int backoffSteps;
    private final int backonSteps;
    private final Function<Integer, Integer> backoffFunction;
    private final Function<Integer, Integer> backonFunction;
    private final List<Integer> statusCodes;
    private final double failurePercentage;
    private final boolean backoffEnabled;
    private boolean fastRecovery;

    protected BackoffConfiguration(Builder builder) {
        this.backoffSteps = builder.backoffSteps;
        this.backonSteps = builder.backonSteps;
        this.backoffFunction = builder.backoffFunction;
        this.backonFunction = builder.backonFunction;
        this.statusCodes = builder.statusCodes;
        this.failurePercentage = builder.failurePercentage;
        this.fastRecovery = builder.fastRecovery;
        this.backoffEnabled = builder.backoffEnabled;
    }

    public int backoffSteps() {
        return this.backoffSteps;
    }

    public int backonSteps() {
        return this.backonSteps;
    }

    public List<Integer> statusCodes() {
        return this.backoffEnabled() ? this.statusCodes : new ArrayList<Integer>();
    }

    public double failurePercentage() {
        return this.failurePercentage;
    }

    public Function<Integer, Integer> backoff() {
        return this.backoffFunction;
    }

    public Function<Integer, Integer> backon() {
        return this.backonFunction;
    }

    public boolean isFastRecovery() {
        return this.fastRecovery;
    }

    private boolean backoffEnabled() {
        return this.backoffEnabled;
    }

    public static class Builder {
        private final boolean backoffEnabled;
        private boolean fastRecovery = false;
        private int backoffSteps = 5;
        private int backonSteps = 3;
        private Function<Integer, Integer> backoffFunction;
        private Function<Integer, Integer> backonFunction;
        private List<Integer> statusCodes = DEFAULT_OUTAGE_STATUS_CODES;
        private double failurePercentage = 100.0;

        public Builder(boolean backoffEnabled) {
            this.backoffEnabled = backoffEnabled;
            this.backoff(2.5, 14.0, 0.6, 5);
            this.backon(2.5, 14.0, 0.3, 3);
        }

        public Builder backoff(double base, double multiplier, int steps, Function<Double, Double> dispersant) {
            this.backoffFunction = new Round(new BoundedExponentialFunction(base, 0, steps, multiplier, dispersant));
            this.backoffSteps = steps;
            return this;
        }

        public Builder backoff(double base, double multiplier, double dispersion, int steps) {
            return this.backoff(base, multiplier, steps, new RangeDispersant(dispersion, 1.0));
        }

        public Builder backon(double base, double multiplier, int steps, Function<Double, Double> dispersant) {
            this.backonFunction = new Round(new BoundedExponentialFunction(base, 0, steps, multiplier, dispersant));
            this.backonSteps = steps;
            return this;
        }

        public Builder backon(double base, double multiplier, double dispersion, int steps) {
            return this.backon(base, multiplier, steps, new RangeDispersant(dispersion, 1.0));
        }

        public Builder statusCodes(List<Integer> statusCodes) {
            this.statusCodes = statusCodes;
            return this;
        }

        public Builder statusCodes(Integer ... statusCodes) {
            return this.statusCodes(Arrays.asList(statusCodes));
        }

        public Builder failurePercentage(double failurePercentage) {
            this.failurePercentage = failurePercentage;
            return this;
        }

        public Builder fastRecovery() {
            this.fastRecovery = true;
            return this;
        }

        public BackoffConfiguration build() {
            return new BackoffConfiguration(this);
        }
    }
}

