/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.event.InternalEvent;
import org.mule.runtime.core.internal.message.EventInternalContext;
import org.mule.runtime.core.internal.routing.ForeachContext;

class ForeachInternalContextManager {
    ForeachInternalContextManager() {
    }

    private static Optional<ForeachInternalContext> from(CoreEvent event) {
        return Optional.ofNullable((ForeachInternalContext)((InternalEvent)event).getForeachInternalContext());
    }

    public static ForeachContext getContext(CoreEvent event) {
        return ForeachInternalContextManager.from(event).map(ctx -> ctx.get(event)).orElse(null);
    }

    public static void addContext(CoreEvent event, ForeachContext context) {
        ForeachInternalContext foreachInternalContext = ForeachInternalContextManager.from(event).orElseGet(() -> {
            ForeachInternalContext ctx = new ForeachInternalContext();
            ((InternalEvent)event).setForeachInternalContext((EventInternalContext)ctx);
            return ctx;
        });
        foreachInternalContext.put(event, context);
    }

    public static void removeContext(CoreEvent event) {
        ForeachInternalContextManager.from(event).map(ctx -> ctx.remove(event));
    }

    static class ForeachInternalContext
    implements EventInternalContext<ForeachInternalContext> {
        private Map<String, ForeachContext> contexts = new HashMap<String, ForeachContext>();

        ForeachInternalContext() {
        }

        public ForeachContext get(CoreEvent event) {
            return this.contexts.get(event.getContext().getId());
        }

        public void put(CoreEvent event, ForeachContext context) {
            this.contexts.put(event.getContext().getId(), context);
        }

        public ForeachContext remove(CoreEvent event) {
            return this.contexts.remove(event.getContext().getId());
        }

        public ForeachInternalContext copy() {
            ForeachInternalContext other = new ForeachInternalContext();
            other.contexts.putAll(this.contexts);
            return other;
        }
    }
}

