/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import javax.transaction.TransactionManager;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.profiling.ProfilingDataProducer;
import org.mule.runtime.api.profiling.ProfilingService;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;
import org.mule.runtime.api.profiling.type.context.TransactionProfilingEventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.execution.ExecutionTemplate;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.AbstractMessageProcessorOwner;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.api.transaction.TransactionUtils;
import org.mule.runtime.core.internal.exception.ErrorHandler;
import org.mule.runtime.core.internal.exception.GlobalErrorHandler;
import org.mule.runtime.core.internal.transaction.MuleTransactionConfig;
import org.mule.runtime.core.internal.transaction.TransactionAdapter;
import org.mule.runtime.core.internal.util.rx.ReactorTransactionUtils;
import org.mule.runtime.core.privileged.execution.TransactionalExecutionTemplate;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.Scope;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.transaction.TransactionConfig;
import org.mule.runtime.tracer.api.component.ComponentTracer;
import org.mule.runtime.tracer.api.component.ComponentTracerFactory;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public class TryScope
extends AbstractMessageProcessorOwner
implements Scope {
    private static final Logger LOGGER = LoggerFactory.getLogger(TryScope.class);
    protected MessageProcessorChain nestedChain;
    protected MuleTransactionConfig transactionConfig;
    private FlowExceptionHandler messagingExceptionHandler;
    private List<Processor> processors;
    @Inject
    private MuleConfiguration muleConfiguration;
    @Inject
    private NotificationDispatcher notificationDispatcher;
    @Inject
    private Optional<TransactionManager> transactionManager;
    @Inject
    private ProfilingService profilingService;
    @Inject
    private ComponentTracerFactory componentTracerFactory;
    @Inject
    private FeatureFlaggingService featureFlaggingService;
    private ProfilingDataProducer<TransactionProfilingEventContext, Object> continueProducer;
    private ProfilingDataProducer<TransactionProfilingEventContext, Object> startProducer;
    private ProfilingDataProducer<TransactionProfilingEventContext, Object> commitProducer;

    public CoreEvent process(CoreEvent event) throws MuleException {
        return MessageProcessors.processToApply((CoreEvent)event, (ReactiveProcessor)this);
    }

    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        if (this.transactionConfig.getAction() == 6) {
            return Flux.from(publisher).doOnNext(e -> TransactionUtils.profileTransactionAction(this.continueProducer, (ProfilingEventType)RuntimeProfilingEventTypes.TX_CONTINUE, (ComponentLocation)this.getLocation())).transform((Function)this.nestedChain);
        }
        boolean errorAfterTimeout = this.featureFlaggingService.isEnabled((Feature)MuleRuntimeFeature.ERROR_AND_ROLLBACK_TX_WHEN_TIMEOUT);
        TransactionalExecutionTemplate executionTemplate = TransactionalExecutionTemplate.createScopeTransactionalExecutionTemplate((MuleConfiguration)this.muleConfiguration, (NotificationDispatcher)this.notificationDispatcher, (TransactionManager)this.transactionManager.orElse(null), (TransactionConfig)this.transactionConfig, (boolean)errorAfterTimeout);
        I18nMessage txErrorMessage = CoreMessages.errorInvokingMessageProcessorWithinTransaction((Processor)this.nestedChain, (Object)this.transactionConfig);
        return Flux.deferContextual(arg_0 -> this.lambda$apply$3(publisher, (ExecutionTemplate)executionTemplate, txErrorMessage, arg_0));
    }

    private void profileBeforeExecution(boolean txPrevoiuslyActive) {
        if (txPrevoiuslyActive) {
            TransactionUtils.profileTransactionAction(this.continueProducer, (ProfilingEventType)RuntimeProfilingEventTypes.TX_CONTINUE, (ComponentLocation)this.getLocation());
        } else {
            TransactionUtils.profileTransactionAction(this.startProducer, (ProfilingEventType)RuntimeProfilingEventTypes.TX_START, (ComponentLocation)this.getLocation());
        }
    }

    private void profileAfterExecution(boolean txPrevoiuslyActive) {
        if (txPrevoiuslyActive) {
            TransactionUtils.profileTransactionAction(this.continueProducer, (ProfilingEventType)RuntimeProfilingEventTypes.TX_CONTINUE, (ComponentLocation)this.getLocation());
        } else {
            TransactionUtils.profileTransactionAction(this.commitProducer, (ProfilingEventType)RuntimeProfilingEventTypes.TX_COMMIT, (ComponentLocation)this.getLocation());
        }
    }

    private void handlePreviousTransaction(boolean txPrevoiuslyActive, Transaction previousTx, Transaction currentTx) {
        if (!txPrevoiuslyActive && TransactionCoordination.isTransactionActive() || txPrevoiuslyActive && previousTx != currentTx) {
            TransactionAdapter transaction = (TransactionAdapter)currentTx;
            transaction.setComponentLocation(this.getLocation());
        }
    }

    private CoreEvent processBlocking(ContextView ctx, CoreEvent event) throws MuleException {
        try {
            return (CoreEvent)Mono.just((Object)event).contextWrite(ReactorTransactionUtils.popTxFromSubscriberContext()).transform((Function)this.nestedChain).onErrorStop().contextWrite(innerCtx -> innerCtx.put((Object)"messageProcessors.withinProcessToApply", (Object)true).put((Object)"recreateRouter", (Object)true)).contextWrite(ReactorTransactionUtils.pushTxToSubscriberContext((String)this.getLocation().getLocation())).contextWrite(ctx).block();
        }
        catch (Throwable e) {
            if (e.getCause() instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw Exceptions.rxExceptionToMuleException((Throwable)e);
        }
    }

    private Transaction getCurrentTx() {
        return TransactionCoordination.getInstance().getTransaction();
    }

    public void setExceptionListener(FlowExceptionHandler exceptionListener) {
        this.messagingExceptionHandler = exceptionListener;
    }

    public void setTransactionConfig(MuleTransactionConfig transactionConfig) {
        this.transactionConfig = transactionConfig;
    }

    public MuleTransactionConfig getTransactionConfig() {
        return this.transactionConfig;
    }

    public void setMessageProcessors(List<Processor> processors) {
        this.processors = processors;
    }

    public void initialise() throws InitialisationException {
        if (this.messagingExceptionHandler == null) {
            this.messagingExceptionHandler = this.muleContext.getDefaultErrorHandler(Optional.of(this.getRootContainerLocation().toString()));
            if (this.shouldSetLocation()) {
                ((ErrorHandler)this.messagingExceptionHandler).setExceptionListenersLocation(this.getLocation());
            }
        }
        this.nestedChain = MessageProcessors.buildNewChainWithListOfProcessors((Optional)MessageProcessors.getProcessingStrategy((ConfigurationComponentLocator)this.locator, (Component)this), this.processors, (FlowExceptionHandler)this.messagingExceptionHandler, (String)this.getLocation().getLocation(), (ComponentTracer)this.componentTracerFactory.fromComponent((Component)this, "try-scope-inner-chain", ""));
        LifecycleUtils.initialiseIfNeeded((Object)this.messagingExceptionHandler, (boolean)true, (MuleContext)this.muleContext);
        if (this.messagingExceptionHandler instanceof GlobalErrorHandler) {
            ((GlobalErrorHandler)this.messagingExceptionHandler).addComponentReference(this.getLocation());
        }
        this.transactionConfig.setMuleContext(this.muleContext);
        this.continueProducer = this.profilingService.getProfilingDataProducer(RuntimeProfilingEventTypes.TX_CONTINUE);
        this.startProducer = this.profilingService.getProfilingDataProducer(RuntimeProfilingEventTypes.TX_START);
        this.commitProducer = this.profilingService.getProfilingDataProducer(RuntimeProfilingEventTypes.TX_COMMIT);
        super.initialise();
    }

    private boolean shouldSetLocation() {
        return !(this.messagingExceptionHandler instanceof GlobalErrorHandler) && this.messagingExceptionHandler instanceof ErrorHandler;
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.messagingExceptionHandler, (Logger)LOGGER);
        super.dispose();
    }

    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded((Object)this.messagingExceptionHandler);
        super.start();
    }

    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)this.messagingExceptionHandler);
        super.stop();
    }

    protected List<Processor> getOwnedMessageProcessors() {
        return Collections.singletonList(this.nestedChain);
    }

    public ReactiveProcessor.ProcessingType getProcessingType() {
        byte txAction = this.transactionConfig.getAction();
        if (txAction == 1 || txAction == 2) {
            return ReactiveProcessor.ProcessingType.BLOCKING;
        }
        return ReactiveProcessor.ProcessingType.CPU_LITE;
    }

    void setComponentTracerFactory(ComponentTracerFactory componentTracerFactory) {
        this.componentTracerFactory = componentTracerFactory;
    }

    void setProfilingService(ProfilingService profilingService) {
        this.profilingService = profilingService;
    }

    void setMuleConfiguration(MuleConfiguration configuration) {
        this.muleConfiguration = configuration;
    }

    void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = Optional.of(transactionManager);
    }

    void setNotificationDispatcher(NotificationDispatcher notificationDispatcher) {
        this.notificationDispatcher = notificationDispatcher;
    }

    private /* synthetic */ Publisher lambda$apply$3(Publisher publisher, ExecutionTemplate executionTemplate, I18nMessage txErrorMessage, ContextView ctx) {
        return Flux.from((Publisher)publisher).handle((event, sink) -> {
            boolean txPrevoiuslyActive = TransactionCoordination.isTransactionActive();
            Transaction previousTx = this.getCurrentTx();
            try {
                sink.next((Object)((CoreEvent)executionTemplate.execute(() -> {
                    this.handlePreviousTransaction(txPrevoiuslyActive, previousTx, this.getCurrentTx());
                    this.profileBeforeExecution(txPrevoiuslyActive);
                    CoreEvent result = this.processBlocking(ctx, (CoreEvent)event);
                    this.profileAfterExecution(txPrevoiuslyActive);
                    return result;
                })));
            }
            catch (Exception e) {
                Throwable unwrapped = Exceptions.unwrap((Throwable)e);
                if (unwrapped instanceof MuleException) {
                    sink.error(unwrapped);
                }
                sink.error((Throwable)new DefaultMuleException(txErrorMessage, unwrapped));
            }
        });
    }
}

