/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.bti.internal.jdbc;

import bitronix.tm.resource.jdbc.PoolingDataSource;
import com.mulesoft.mule.runtime.bti.internal.jdbc.BitronixConnectionWrapper;
import com.mulesoft.mule.runtime.bti.internal.transaction.TransactionManagerWrapper;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.internal.transaction.xa.XaResourceFactoryHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitronixXaDataSourceWrapper
extends AbstractComponent
implements DataSource,
Initialisable,
XaResourceFactoryHolder,
Disposable {
    private final PoolingDataSource xaDataSource;
    private final TransactionManager txManager;
    private final XADataSource wrappedDataSource;
    private static final Logger LOGGER = LoggerFactory.getLogger(BitronixXaDataSourceWrapper.class);

    public BitronixXaDataSourceWrapper(PoolingDataSource xaDataSource, XADataSource dataSource, TransactionManager txManager) {
        this.xaDataSource = xaDataSource;
        this.wrappedDataSource = dataSource;
        this.txManager = txManager;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.xaDataSource.getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.xaDataSource.setLoginTimeout(seconds);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.xaDataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.xaDataSource.setLogWriter(out);
    }

    @Override
    public Connection getConnection() throws SQLException {
        ClassLoader currentTccl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(BitronixXaDataSourceWrapper.class.getClassLoader());
        try {
            this.safeInitializeXaDataSource();
            BitronixConnectionWrapper bitronixConnectionWrapper = new BitronixConnectionWrapper(this.xaDataSource.getConnection());
            return bitronixConnectionWrapper;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentTccl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        ClassLoader currentTccl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(BitronixXaDataSourceWrapper.class.getClassLoader());
        try {
            this.safeInitializeXaDataSource();
            BitronixConnectionWrapper bitronixConnectionWrapper = new BitronixConnectionWrapper(this.xaDataSource.getConnection(username, password));
            return bitronixConnectionWrapper;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentTccl);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> interfase) throws SQLException {
        return this.xaDataSource.isWrapperFor(interfase);
    }

    @Override
    public <T> T unwrap(Class<T> interfase) throws SQLException {
        return (T)this.xaDataSource.unwrap(interfase);
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("btm does not support this feature yet");
    }

    public void close() {
        this.xaDataSource.close();
    }

    public PoolingDataSource getWrappedDataSource() {
        return this.xaDataSource;
    }

    public void initialise() throws InitialisationException {
        if (!(this.txManager instanceof TransactionManagerWrapper)) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Cannot use a Bitronix data source pool without using Bitronix transaction manager"), (Initialisable)this);
        }
    }

    public Object getHoldObject() {
        return this.wrappedDataSource;
    }

    public void dispose() {
        this.xaDataSource.close();
    }

    private void safeInitializeXaDataSource() {
        try {
            this.xaDataSource.init();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            this.xaDataSource.setMinPoolSize(0);
            this.xaDataSource.init();
        }
    }
}

