/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence.type.adapter;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.mule.metadata.api.annotation.EnumAnnotation;

public final class EnumTypeAnnotationTypeAdapter
extends TypeAdapter<EnumAnnotation> {
    private static final String TYPE = "type";
    private static final String VALUES = "values";
    private static final Gson GSON = new Gson();

    public void write(JsonWriter out, EnumAnnotation value) throws IOException {
        Class<?> componentType = value.getValues().getClass().getComponentType();
        Class<?> arrayType = value.getValues().getClass();
        out.beginObject();
        out.name(TYPE);
        out.value(arrayType.getName());
        out.name(VALUES);
        out.beginArray();
        for (Object object : value.getValues()) {
            GSON.toJson(object, componentType, out);
        }
        out.endArray();
        out.endObject();
    }

    public EnumAnnotation read(JsonReader in) throws IOException {
        Object array;
        JsonElement parse2 = new JsonParser().parse(in);
        JsonObject enumAnnotation = parse2.getAsJsonObject();
        String arrayType = enumAnnotation.get(TYPE).getAsString();
        JsonArray iterator = enumAnnotation.get(VALUES).getAsJsonArray();
        try {
            Class<?> aClass = Class.forName(arrayType);
            array = GSON.fromJson((JsonElement)iterator, aClass);
        }
        catch (ClassNotFoundException e) {
            array = GSON.fromJson((JsonElement)iterator, Object[].class);
        }
        return new EnumAnnotation((Object[])array);
    }
}

