/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.bootstrap;

import java.util.Collection;
import java.util.HashSet;
import java.util.ServiceLoader;
import org.togglz.core.bootstrap.TogglzBootstrap;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.manager.FeatureManagerBuilder;
import org.togglz.core.manager.TogglzConfig;
import org.togglz.core.spi.BeanFinder;
import org.togglz.core.util.Strings;
import org.togglz.core.util.Validate;

public class FeatureManagerBootstrapper {
    public FeatureManager createFeatureManager(Object context) {
        TogglzBootstrap togglzBootstrap = this.lookupBean(TogglzBootstrap.class, context);
        if (togglzBootstrap != null) {
            FeatureManager manager = togglzBootstrap.createFeatureManager();
            Validate.notNull(manager, togglzBootstrap.getClass().getName() + " returned null");
            return manager;
        }
        TogglzConfig togglzConfig = this.lookupBean(TogglzConfig.class, context);
        if (togglzConfig != null) {
            return new FeatureManagerBuilder().togglzConfig(togglzConfig).build();
        }
        throw new IllegalStateException("Could not find any implementation of TogglzConfig or TogglzBootstrap. Please make sure that you have added the required integration modules to your project or register the implementation in your web.xml as described in the 'Configuration' chapter of the documentation.");
    }

    private <T> T lookupBean(Class<T> clazz, Object context) {
        HashSet<T> impls = new HashSet<T>();
        for (BeanFinder beanFinder : ServiceLoader.load(BeanFinder.class)) {
            Collection<T> result = beanFinder.find(clazz, context);
            if (result == null) continue;
            impls.addAll(result);
        }
        if (impls.size() > 1) {
            throw new IllegalStateException("Found more than one implementation of the " + clazz.getSimpleName() + " interface: " + Strings.joinClassNames(impls));
        }
        if (!impls.isEmpty()) {
            return (T)impls.iterator().next();
        }
        return null;
    }
}

