/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.analytics.servicemesh;

import com.mulesoft.mule.runtime.gw.analytics.injector.HeaderInjector;
import com.mulesoft.mule.runtime.gw.api.analytics.AnalyticsHttpEvent;
import com.mulesoft.mule.runtime.gw.config.AnalyticsConfiguration;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceMeshHeaderInjector
extends HeaderInjector {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceMeshHeaderInjector.class);
    public static final String SEPARATOR = "|";
    private final AnalyticsConfiguration configuration = new AnalyticsConfiguration();

    public void injectHeader(Object attributes, AnalyticsHttpEvent event) {
        this.injectHeader(attributes, this.configuration.getServiceMeshHeader(), this.generateCheckHeader(event));
    }

    private String generateCheckHeader(AnalyticsHttpEvent event) {
        StringBuilder builder = new StringBuilder();
        builder.append(event.getOrgId()).append(SEPARATOR);
        builder.append(event.getApiId()).append(SEPARATOR);
        builder.append(event.getApiVersionId()).append(SEPARATOR);
        builder.append(event.getClientId()).append(SEPARATOR);
        builder.append(event.getRequestDisposition()).append(SEPARATOR);
        if (event.getPolicyViolation() != null) {
            builder.append(event.getPolicyViolation().getPolicyId()).append(SEPARATOR);
            builder.append(event.getPolicyViolation().getPolicyName()).append(SEPARATOR);
            builder.append(event.getPolicyViolation().getCategory()).append(SEPARATOR);
            builder.append(event.getPolicyViolation().getOutcome().getName());
        }
        String decoded = builder.toString();
        String encoded = Base64.getUrlEncoder().encodeToString(decoded.getBytes());
        LOGGER.debug("Injecting {} header: {} ({})", new Object[]{this.configuration.getServiceMeshHeader(), encoded, decoded});
        return encoded;
    }
}

