/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.cfg.internal.node.errorhandling;

import java.util.Map;
import java.util.function.Predicate;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;
import org.mule.runtime.cfg.api.ChainExecutionPathTreeVisitor;
import org.mule.runtime.cfg.internal.node.errorhandling.ErrorHandlerNode;

public class ErrorHandlerWrapper
implements ChainExecutionPathTree {
    private final Map<ErrorType, ErrorHandlerNode> errorHandlers;

    public ErrorHandlerWrapper(Map<ErrorType, ErrorHandlerNode> errorHandlers) {
        this.errorHandlers = errorHandlers;
    }

    @Override
    public void accept(ChainExecutionPathTreeVisitor visitor) {
        this.errorHandlers.keySet().forEach(errorType -> this.errorHandlers.get(errorType).accept(visitor, (ErrorType)errorType));
    }

    @Override
    public ComponentAst getComponentAst() {
        return null;
    }

    @Override
    public boolean anyExecutionPathContains(Predicate<ChainExecutionPathTree> predicate) {
        return this.errorHandlers.values().stream().anyMatch(e -> e.anyExecutionPathContains(predicate));
    }

    @Override
    public boolean allExecutionPathsContain(Predicate<ChainExecutionPathTree> predicate) {
        return this.errorHandlers.values().stream().allMatch(e -> e.allExecutionPathsContain(predicate));
    }
}

