/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.client.httpclient;

import com.google.common.collect.Lists;
import com.mulesoft.mule.runtime.gw.api.config.PlatformClientConfiguration;
import com.mulesoft.mule.runtime.gw.client.httpclient.GatewayHttpClient;
import com.mulesoft.mule.runtime.gw.client.httpclient.GatewayHttpClientBuildException;
import com.mulesoft.mule.runtime.gw.client.httpclient.connection.RestartableConnectionManager;
import com.mulesoft.mule.runtime.gw.client.httpclient.interceptors.HttpRequestResponseInterceptor;
import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;

public class GatewayHttpClientBuilder {
    private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(GatewayHttpClientBuilder.class);
    private HttpClientBuilder clientBuilder = HttpClientBuilder.create();
    private RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
    private SocketConfig.Builder socketConfigBuilder = SocketConfig.custom();
    private boolean sslValidationEnabled;
    private int requestTimout;

    public GatewayHttpClientBuilder withClientConfiguration(PlatformClientConfiguration clientConfiguration) {
        this.timeouts(clientConfiguration);
        this.setupProxy(clientConfiguration);
        return this;
    }

    public GatewayHttpClientBuilder withRequestResponseInterceptors(HttpRequestResponseInterceptor ... interceptors) {
        Arrays.asList(interceptors).forEach(httpRequestResponseInterceptor -> {
            this.clientBuilder.addInterceptorLast((HttpRequestInterceptor)httpRequestResponseInterceptor);
            this.clientBuilder.addInterceptorLast((HttpResponseInterceptor)httpRequestResponseInterceptor);
        });
        return this;
    }

    public GatewayHttpClientBuilder withSslValidationEnabled(boolean enabled) {
        this.sslValidationEnabled = enabled;
        return this;
    }

    public GatewayHttpClient build() {
        RestartableConnectionManager connectionManager = this.setupConnectionManager();
        RequestConfig requestConfig = this.requestConfigBuilder.build();
        SocketConfig socketConfig = this.socketConfigBuilder.build();
        this.clientBuilder.setDefaultRequestConfig(requestConfig);
        this.clientBuilder.setDefaultSocketConfig(socketConfig);
        this.clientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        return new GatewayHttpClient((HttpClient)this.clientBuilder.build(), connectionManager, requestConfig.getConnectTimeout() / 2, this.requestTimout);
    }

    private void timeouts(PlatformClientConfiguration timeoutConfiguration) {
        this.socketConfigBuilder.setSoTimeout((int)timeoutConfiguration.getReadTimeout().inMillis());
        this.requestConfigBuilder.setSocketTimeout((int)timeoutConfiguration.getReadTimeout().inMillis());
        this.requestConfigBuilder.setConnectTimeout((int)timeoutConfiguration.getConnectTimeout().inMillis());
        this.requestConfigBuilder.setConnectionRequestTimeout((int)timeoutConfiguration.getConnectTimeout().inMillis());
        this.requestTimout = (int)timeoutConfiguration.getRequestTimeout().inMillis();
    }

    protected SSLContext getSslContext() {
        TrustManager[] certs = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        }};
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(null, certs, new SecureRandom());
            return ctx;
        }
        catch (GeneralSecurityException ex) {
            throw new GatewayHttpClientBuildException("General Security Exception when initializing SSL context");
        }
    }

    protected RestartableConnectionManager setupConnectionManager() {
        try {
            if (!this.sslValidationEnabled) {
                return new RestartableConnectionManager(() -> new PoolingHttpClientConnectionManager(this.connectionSocketFactory()));
            }
            return new RestartableConnectionManager(PoolingHttpClientConnectionManager::new);
        }
        catch (Exception e) {
            throw new GatewayHttpClientBuildException(e.getMessage());
        }
    }

    protected Registry<ConnectionSocketFactory> connectionSocketFactory() {
        return RegistryBuilder.create().register("https", (Object)new SSLConnectionSocketFactory(this.getSslContext(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).build();
    }

    private void setupProxy(PlatformClientConfiguration configuration) {
        if (configuration.getProxyHost() != null) {
            HttpHost proxy = new HttpHost(configuration.getProxyHost(), configuration.getProxyPort());
            this.requestConfigBuilder.setProxy(proxy);
            if (configuration.getProxyUserName() != null) {
                this.requestConfigBuilder.setProxyPreferredAuthSchemes((Collection)Lists.newArrayList((Object[])new String[]{"Basic", "Digest", "NTLM"}));
                AuthScope ntlmScope = new AuthScope(configuration.getProxyHost(), configuration.getProxyPort(), AuthScope.ANY_REALM, "NTLM");
                AuthScope basicScope = new AuthScope(configuration.getProxyHost(), configuration.getProxyPort(), AuthScope.ANY_REALM, "Basic");
                AuthScope spnegoScope = new AuthScope(null, -1, null);
                NTCredentials ntCredentials = this.ntCredentials(configuration);
                UsernamePasswordCredentials basicCredentials = new UsernamePasswordCredentials(configuration.getProxyUserName(), configuration.getProxyPassword());
                Credentials spnegoCredentials = this.spnegoCredentials();
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(basicScope, (Credentials)basicCredentials);
                credentialsProvider.setCredentials(ntlmScope, (Credentials)ntCredentials);
                credentialsProvider.setCredentials(spnegoScope, spnegoCredentials);
                if (this.hasValidKerberosConfiguration(configuration)) {
                    LOGGER.debug("Found valid Kerberos configuration. Will be using Kerberos authentication method for proxy login.");
                    this.setupKerberosProperties(configuration);
                    this.requestConfigBuilder.setProxyPreferredAuthSchemes((Collection)Lists.newArrayList((Object[])new String[]{"Negotiate"}));
                }
                this.clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
        }
    }

    private void setupKerberosProperties(PlatformClientConfiguration configuration) {
        System.setProperty("java.security.krb5.conf", configuration.getProxyKrb5ConfigurationPath());
        System.setProperty("java.security.auth.login.config", "=" + configuration.getProxyJaasConfigurationPath());
        Security.setProperty("java.security.mule.gw.krb5.login.user", configuration.getProxyUserName());
        Security.setProperty("java.security.mule.gw.krb5.login.password", configuration.getProxyPassword());
        Security.setProperty("auth.login.defaultCallbackHandler", "com.mulesoft.mule.runtime.gw.client.httpclient.krb5.KerberosCallbackHandler");
        System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
    }

    private boolean hasValidKerberosConfiguration(PlatformClientConfiguration configuration) {
        if (configuration.getProxyPassword() == null) {
            LOGGER.debug("Proxy password not set, Gateway will not be using Kerberos authentication method.");
            return false;
        }
        if (configuration.getProxyKrb5ConfigurationPath() == null) {
            LOGGER.debug("Proxy krb5 config file not set, Gateway will not be using Kerberos authentication method.");
            return false;
        }
        if (configuration.getProxyJaasConfigurationPath() == null) {
            LOGGER.debug("Proxy jaas config file not set, Gateway will not be using Kerberos authentication method.");
            return false;
        }
        return true;
    }

    private NTCredentials ntCredentials(PlatformClientConfiguration configuration) {
        NTCredentials ntCredentials;
        if (configuration.getProxyUserName().contains("\\")) {
            String domain = StringUtils.substringBefore((String)configuration.getProxyUserName(), (String)"\\");
            String username = StringUtils.substringAfter((String)configuration.getProxyUserName(), (String)"\\");
            ntCredentials = new NTCredentials(username, configuration.getProxyPassword(), "", domain);
        } else {
            ntCredentials = new NTCredentials(configuration.getProxyUserName(), configuration.getProxyPassword(), "", "");
        }
        return ntCredentials;
    }

    private Credentials spnegoCredentials() {
        return new Credentials(){

            public String getPassword() {
                return null;
            }

            public Principal getUserPrincipal() {
                return null;
            }
        };
    }
}

