/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.queue;

import com.mulesoft.mule.runtime.gw.queue.CircularQueueStrategy;
import com.mulesoft.mule.runtime.gw.queue.ConcurrentSizeLimitedQueue;
import com.mulesoft.mule.runtime.gw.queue.DefaultSizeLimitedQueue;
import com.mulesoft.mule.runtime.gw.queue.SizeLimitedPartitionedQueue;
import com.mulesoft.mule.runtime.gw.queue.SizeLimitedQueue;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.function.Function;

public class SizeLimitedQueueFactory {
    public <T> SizeLimitedQueue<T> createCircularQueue(Queue<T> queue, long limit) {
        return new DefaultSizeLimitedQueue<T>(queue, new CircularQueueStrategy(), limit);
    }

    public <T> SizeLimitedQueue<T> createConcurrentCircularQueue(ArrayDeque<T> queue, int limit) {
        return new ConcurrentSizeLimitedQueue<T>(this.createCircularQueue(queue, limit));
    }

    public <T> SizeLimitedPartitionedQueue<T> createCircularPartitionedQueue(Queue<T> queue, long limit, long partitionLimit, Function<T, String> partitioner) {
        return new SizeLimitedPartitionedQueue<T>(queue, limit, partitionLimit, partitioner, new CircularQueueStrategy());
    }
}

